/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ui.SequenceDiagramUIPlugin;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.ISEComplexMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;

public abstract class AbstractSequenceInteractionValidator {
    protected static ISEComplexMoveValidator lastValidator;
    protected static ChangeBoundsRequest lastRequest;
    protected boolean valid = true;
    protected RequestQuery request;
    protected Range expansionZone = Range.emptyRange();
    protected Set<ISequenceEvent> eventInError = new HashSet<ISequenceEvent>();
    protected Set<Integer> invalidPositions = new HashSet<Integer>();
    protected Set<Range> invalidRanges = new HashSet<Range>();
    protected final Collection<ISequenceEvent> movedElements = new ArrayList<ISequenceEvent>();
    protected Collection<Range> createdElements = new ArrayList<Range>();
    protected final Collection<Message> startReflexiveMessageToResize = new HashSet<Message>();
    protected final Collection<Message> endReflexiveMessageToResize = new HashSet<Message>();
    protected boolean validationDone;
    protected boolean initialized;

    public AbstractSequenceInteractionValidator(RequestQuery request) {
        this.request = request;
    }

    public abstract SequenceDiagram getDiagram();

    public abstract Function<ISequenceEvent, Range> getRangeFunction();

    protected abstract void doValidation();

    public final boolean isValid() {
        this.validate();
        return this.valid;
    }

    public final void validate() {
        try {
            if (!this.validationDone) {
                this.doValidation();
                this.validationDone = true;
            }
        }
        catch (ClassCastException e) {
            Status status = new Status(2, "org.eclipse.sirius.diagram.sequence.ui", "Sequence diagram might need to be refreshed.", (Throwable)e);
            SequenceDiagramUIPlugin.getPlugin().getLog().log((IStatus)status);
            this.valid = false;
        }
    }

    public Collection<ISequenceEvent> getMovedElements() {
        return this.movedElements;
    }

    public Collection<Range> getCreatedElements() {
        return this.createdElements;
    }

    public Collection<Message> getResizedStartMessages() {
        return this.startReflexiveMessageToResize;
    }

    public Collection<Message> getResizedEndMessages() {
        return this.endReflexiveMessageToResize;
    }

    public Range getExpansionZone() {
        return this.expansionZone;
    }

    public Collection<ISequenceEvent> getEventsInError() {
        return this.eventInError;
    }

    public Collection<Integer> getInvalidPostions() {
        return this.invalidPositions;
    }

    public Collection<Range> getInvalidRanges() {
        return this.invalidRanges;
    }
}

