/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.options;

import org.eclipse.elk.alg.radial.RadialLayoutProvider;
import org.eclipse.elk.alg.radial.options.AnnulusWedgeCriteria;
import org.eclipse.elk.alg.radial.options.CompactionStrategy;
import org.eclipse.elk.alg.radial.options.RadialMetaDataProvider;
import org.eclipse.elk.alg.radial.options.RadialTranslationStrategy;
import org.eclipse.elk.alg.radial.options.SortingStrategy;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;

public class RadialOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.radial";
    public static final IProperty<KVector> POSITION = CoreOptions.POSITION;
    public static final IProperty<Double> SPACING_NODE_NODE = CoreOptions.SPACING_NODE_NODE;
    public static final IProperty<Integer> COMPACTION_STEP_SIZE = RadialMetaDataProvider.COMPACTION_STEP_SIZE;
    public static final IProperty<CompactionStrategy> COMPACTOR = RadialMetaDataProvider.COMPACTOR;
    public static final IProperty<RadialTranslationStrategy> OPTIMIZATION_CRITERIA = RadialMetaDataProvider.OPTIMIZATION_CRITERIA;
    public static final IProperty<Integer> ORDER_ID = RadialMetaDataProvider.ORDER_ID;
    public static final IProperty<Double> RADIUS = RadialMetaDataProvider.RADIUS;
    public static final IProperty<SortingStrategy> SORTER = RadialMetaDataProvider.SORTER;
    public static final IProperty<AnnulusWedgeCriteria> WEDGE_CRITERIA = RadialMetaDataProvider.WEDGE_CRITERIA;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Radial").description("A radial layout provider which is based on the algorithm of Peter Eades published in \"Drawing free trees.\", published by International Institute for Advanced Study of Social Information Science, Fujitsu Limited in 1991. The radial layouter takes a tree and places the nodes in radial order around the root. The nodes of the same tree level are placed on the same radius.").providerFactory((IFactory)new RadialFactory()).category(ALGORITHM_ID).melkBundleName(null).definingBundleId("org.eclipse.elk.alg.radial").imagePath("images/radial_layout.png").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.position", POSITION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", SPACING_NODE_NODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.radial.compactionStepSize", COMPACTION_STEP_SIZE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.radial.compactor", COMPACTOR.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.radial.optimizationCriteria", OPTIMIZATION_CRITERIA.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.radial.orderId", ORDER_ID.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.radial.radius", RADIUS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.radial.sorter", SORTER.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.radial.wedgeCriteria", WEDGE_CRITERIA.getDefault());
    }

    public static class RadialFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            RadialLayoutProvider provider = new RadialLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

