/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.preserveorder;

import java.util.Comparator;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;

public class ModelOrderPortComparator
implements Comparator<LPort> {
    private final Map<LNode, Integer> targetNodeModelOrder;
    private final Layer previousLayer;

    public ModelOrderPortComparator(Layer previousLayer, Map<LNode, Integer> targetNodeModelOrder) {
        this.previousLayer = previousLayer;
        this.targetNodeModelOrder = targetNodeModelOrder;
    }

    @Override
    public int compare(LPort p1, LPort p2) {
        if (!p1.getIncomingEdges().isEmpty() && !p2.getIncomingEdges().isEmpty()) {
            LNode p2Node;
            LNode p1Node = p1.getIncomingEdges().get(0).getSource().getNode();
            if (((Object)((Object)p1Node)).equals((Object)(p2Node = p2.getIncomingEdges().get(0).getSource().getNode()))) {
                return Integer.compare((Integer)p1.getIncomingEdges().get(0).getProperty(InternalProperties.MODEL_ORDER), (Integer)p2.getIncomingEdges().get(0).getProperty(InternalProperties.MODEL_ORDER));
            }
            for (LNode previousNode : this.previousLayer) {
                if (((Object)((Object)previousNode)).equals((Object)p1Node)) {
                    return 1;
                }
                if (!((Object)((Object)previousNode)).equals((Object)p2Node)) continue;
                return -1;
            }
        }
        if (!p1.getOutgoingEdges().isEmpty() && !p2.getOutgoingEdges().isEmpty()) {
            LNode p1TargetNode = (LNode)((Object)p1.getProperty(InternalProperties.LONG_EDGE_TARGET_NODE));
            LNode p2TargetNode = (LNode)((Object)p2.getProperty(InternalProperties.LONG_EDGE_TARGET_NODE));
            int p1Order = (Integer)p1.getOutgoingEdges().get(0).getProperty(InternalProperties.MODEL_ORDER);
            int p2Order = (Integer)p2.getOutgoingEdges().get(0).getProperty(InternalProperties.MODEL_ORDER);
            if (p1TargetNode != null && ((Object)((Object)p1TargetNode)).equals((Object)p2TargetNode)) {
                return Integer.compare(p1Order, p2Order);
            }
            if (this.targetNodeModelOrder.containsKey((Object)p1TargetNode)) {
                p1Order = this.targetNodeModelOrder.get((Object)p1TargetNode);
            }
            if (this.targetNodeModelOrder.containsKey((Object)p2TargetNode)) {
                p2Order = this.targetNodeModelOrder.get((Object)p2TargetNode);
            }
            return Integer.compare(p1Order, p2Order);
        }
        if (!p1.getIncomingEdges().isEmpty() && !p2.getOutgoingEdges().isEmpty()) {
            return 1;
        }
        return -1;
    }
}

