/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.resource;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.resource.ResourceLoaderListener;
import org.eclipse.sirius.common.tools.api.resource.ResourceTools;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.part.Messages;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ecore.extender.tool.api.ModelUtils;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class CustomSiriusDocumentProvider
extends AbstractDocumentProvider
implements IDiagramDocumentProvider {
    private TransactionalEditingDomain transactionalEditingDomain;

    public CustomSiriusDocumentProvider() {
    }

    public CustomSiriusDocumentProvider(TransactionalEditingDomain transactionalEditingDomain) {
        this.transactionalEditingDomain = transactionalEditingDomain;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (!(element instanceof FileEditorInput) && !(element instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius.diagram", 0, MessageFormat.format(Messages.SiriusDocumentProvider_IncorrectInputError, element, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"), null));
        }
        IDocument document = this.createEmptyDocument();
        this.setDocumentContent(document, (IEditorInput)element);
        this.setupDocument(element, document);
        return document;
    }

    protected void setDocumentContent(IDocument document, IEditorInput element) throws CoreException {
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        IPermissionAuthority authority = null;
        if (domain != null) {
            authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(domain.getResourceSet());
        }
        if (authority != null) {
            authority.setListening(false);
        }
        try {
            this.doSetDocumentContent(document, element, domain);
        }
        finally {
            if (authority != null) {
                authority.setListening(true);
            }
        }
    }

    private void doSetDocumentContent(IDocument document, IEditorInput element, TransactionalEditingDomain domain) throws CoreException {
        block6: {
            IPermissionAuthority authority = null;
            if (domain != null) {
                authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(domain.getResourceSet());
                authority.setReportIssues(false);
                try {
                    if (element instanceof FileEditorInput) {
                        this.caseFileEditorInput(document, (FileEditorInput)element, domain);
                        break block6;
                    }
                    if (element instanceof URIEditorInput) {
                        this.caseURIEditorInput(document, (URIEditorInput)element, domain);
                        break block6;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius.diagram", 0, MessageFormat.format(Messages.SiriusDocumentProvider_IncorrectInputError, element, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"), null));
                }
                finally {
                    authority.setReportIssues(true);
                }
            }
        }
    }

    private void caseFileEditorInput(IDocument document, FileEditorInput fileEditorInput, TransactionalEditingDomain domain) throws CoreException {
        IStorage storage = fileEditorInput.getStorage();
        ResourceLoaderListener listener = ResourceTools.attachResourceLoaderListener((ResourceSet)domain.getResourceSet());
        Diagram diagram = DiagramIOUtil.load((TransactionalEditingDomain)domain, (IStorage)storage, (boolean)true, (IProgressMonitor)this.getProgressMonitor());
        for (Resource res : listener.getLoadedResources()) {
            DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.RESOLVE_ALL_KEY);
            ModelUtils.resolveAll((Resource)res);
            DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.RESOLVE_ALL_KEY);
        }
        ResourceTools.detachResourceLoaderListener((ResourceSet)domain.getResourceSet(), (ResourceLoaderListener)listener);
        document.setContent((Object)diagram);
    }

    private void caseURIEditorInput(IDocument document, URIEditorInput element, TransactionalEditingDomain domain) throws CoreException {
        URI uri = element.getURI();
        Resource resource = null;
        try {
            if (uri.trimFragment().isEmpty()) {
                return;
            }
            resource = domain.getResourceSet().getResource(uri.trimFragment(), true);
            if (!resource.isLoaded()) {
                try {
                    HashMap options = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
                    resource.load(options);
                }
                catch (IOException e) {
                    resource.unload();
                    throw e;
                }
            }
            if (uri.fragment() != null) {
                EObject rootElement = resource.getEObject(uri.fragment());
                if (rootElement instanceof Diagram) {
                    EObject viewpointDiagram = ViewUtil.resolveSemanticElement((View)((Diagram)rootElement));
                    if (viewpointDiagram instanceof DRepresentation) {
                        DialectManager.INSTANCE.getDescription((DRepresentation)viewpointDiagram);
                    }
                    ModelAccessor dummy = new ModelAccessor();
                    dummy.init(((Diagram)rootElement).eResource().getResourceSet());
                    document.setContent((Object)rootElement);
                } else {
                    DiagramUIPlugin.getPlugin().getResourceMissingDocumentProvider().setDocumentContent(document, (IEditorInput)element);
                }
            } else {
                for (EObject rootElement : resource.getContents()) {
                    if (!(rootElement instanceof Diagram)) continue;
                    document.setContent((Object)rootElement);
                    ModelAccessor dummy = new ModelAccessor();
                    dummy.init(((Diagram)rootElement).eResource().getResourceSet());
                    return;
                }
                DiagramUIPlugin.getPlugin().getResourceMissingDocumentProvider().setDocumentContent(document, (IEditorInput)element, org.eclipse.sirius.diagram.ui.provider.Messages.CustomSiriusDocumentProvider_useModelExplorerToOpenMsg);
            }
        }
        catch (Exception e) {
            String msg;
            CoreException thrownExcp = null;
            thrownExcp = e instanceof CoreException ? (CoreException)e : new CoreException((IStatus)new Status(4, "org.eclipse.sirius.diagram", 0, (msg = e.getLocalizedMessage()) != null ? msg : Messages.SiriusDocumentProvider_DiagramLoadingError, (Throwable)e));
            throw thrownExcp;
        }
    }

    protected void setupDocument(Object element, IDocument document) {
    }

    protected IDocument createEmptyDocument() {
        DiagramDocument document = new DiagramDocument();
        document.setEditingDomain(this.transactionalEditingDomain);
        return document;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof SessionEditorInput) {
            this.fireElementStateChanging(element);
            ((SessionEditorInput)element).getSession().save(monitor);
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public IEditorInput createInputWithEditingDomain(IEditorInput editorInput, TransactionalEditingDomain domain) {
        return editorInput;
    }

    public IDiagramDocument getDiagramDocument(Object element) {
        IDocument doc = this.getDocument(element);
        if (doc instanceof IDiagramDocument) {
            return (IDiagramDocument)doc;
        }
        return null;
    }

    public boolean isReadOnly(Object element) {
        return false;
    }

    public boolean isModifiable(Object element) {
        SessionEditorInput sessionEditorInput;
        Session session;
        boolean isModifiable = true;
        if (element instanceof SessionEditorInput && (session = (sessionEditorInput = (SessionEditorInput)element).getSession(false)) != null) {
            URI inputURI;
            URI resourceURI;
            ResourceSet resourceSet = session.getTransactionalEditingDomain().getResourceSet();
            Resource resource = resourceSet.getResource(resourceURI = (inputURI = sessionEditorInput.getURI()).trimFragment(), false);
            if (resource == null) {
                DiagramPlugin.getDefault().logError(MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.CustomSiriusDocumentProvider_noCorrespondingResourceMsg, resourceURI.toString()));
                return isModifiable;
            }
            String fragment = inputURI.fragment();
            if (fragment != null) {
                EObject intputEObject = resource.getEObject(fragment);
                IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resourceSet);
                boolean bl = isModifiable = intputEObject != null && permissionAuthority.canEditInstance(intputEObject);
                if (isModifiable && intputEObject instanceof Diagram) {
                    Diagram diagram = (Diagram)intputEObject;
                    EObject diagramElt = diagram.getElement();
                    isModifiable = permissionAuthority.canEditInstance(diagramElt);
                }
            }
        }
        return isModifiable;
    }

    public boolean canSaveDocument(Object element) {
        if (element instanceof SessionEditorInput) {
            Session session = ((SessionEditorInput)element).getSession(false);
            return session != null && session.isOpen() && session.getStatus() == SessionStatus.DIRTY;
        }
        return super.canSaveDocument(element);
    }
}

