/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.ComputedColor;
import org.eclipse.sirius.viewpoint.description.InterpolatedColor;

public class BackgroundUpdater
extends ResourceSetListenerImpl {
    private DDiagram dDiagram;
    private static final NotificationFilter FEATURES_TO_REFACTOR_BACKGROUND = NotificationFilter.NOT_TOUCH;

    public BackgroundUpdater(TransactionalEditingDomain domain, DDiagram dDiagram) {
        super(FEATURES_TO_REFACTOR_BACKGROUND);
        domain.addResourceSetListener((ResourceSetListener)this);
        this.dDiagram = dDiagram;
    }

    public static void refreshDiagramBackgrounds(Session session) {
        EclipseUIUtil.displayAsyncExec(() -> {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
            if (uiSession != null) {
                for (DialectEditor editor : uiSession.getEditors()) {
                    if (!(editor instanceof DDiagramEditorImpl)) continue;
                    DiagramEditPart diagramEditPart = ((DDiagramEditorImpl)editor).getDiagramEditPart();
                    ((DDiagramEditPart)diagramEditPart).configureBackground(diagramEditPart.getFigure());
                }
            }
        });
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        ColorDescription backgroundColor;
        if (this.dDiagram instanceof DSemanticDiagram && ((backgroundColor = ((DSemanticDiagram)this.dDiagram).getDescription().getBackgroundColor()) instanceof InterpolatedColor || backgroundColor instanceof ComputedColor)) {
            Session.of((EObject)this.dDiagram).ifPresent(s -> BackgroundUpdater.refreshDiagramBackgrounds(s));
        }
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }
}

