/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.draw2d.figure.ICollapseMode;

public class NodeQuery {
    private Node node;

    public NodeQuery(Node node) {
        this.node = node;
    }

    public Dimension getCollapsedSize() {
        Dimension expectedDim = ICollapseMode.COLLAPSED_DIMENSION;
        expectedDim = ICollapseMode.MINIMIZED_DIMENSION;
        return expectedDim;
    }

    public Dimension getOriginalDimensionBeforeCollapse() {
        EObject element = this.node.getElement();
        Dimension dim = new Dimension(0, 0);
        if (element instanceof DDiagramElement) {
            CollapseFilter filter = (CollapseFilter)Iterables.getFirst((Iterable)Iterables.filter((Iterable)((DDiagramElement)element).getGraphicalFilters(), (Predicate)Predicates.instanceOf(CollapseFilter.class)), null);
            if (filter == null || filter.getWidth() == 0 || filter.getHeight() == 0) {
                dim.setSize(this.getDefaultDim((DDiagramElement)element));
            } else {
                dim.setSize(new Dimension(filter.getWidth(), filter.getHeight()));
            }
        }
        return dim;
    }

    public boolean isCollapsed() {
        EObject element = this.node.getElement();
        if (element instanceof DDiagramElement) {
            DDiagramElementQuery dDiagramElementQuery = new DDiagramElementQuery((DDiagramElement)element);
            return dDiagramElementQuery.isIndirectlyCollapsed();
        }
        return false;
    }

    public boolean isDirectlyCollapsed() {
        EObject element = this.node.getElement();
        if (element instanceof DDiagramElement) {
            return new DDiagramElementQuery((DDiagramElement)element).isCollapsed();
        }
        return false;
    }

    public boolean isIndirectlyCollapsed() {
        EObject element = this.node.getElement();
        if (element instanceof DDiagramElement) {
            return new DDiagramElementQuery((DDiagramElement)element).isOnlyIndirectlyCollapsed();
        }
        return false;
    }

    protected Dimension getDefaultDim(DDiagramElement element) {
        Dimension dim;
        if (element instanceof DNode) {
            int originalDNodeWidth = ((DNode)element).getWidth();
            int originalDNodeHeight = ((DNode)element).getHeight();
            dim = new Dimension(originalDNodeWidth * 10, originalDNodeHeight * 10);
        } else {
            dim = new Dimension(0, 0);
        }
        return dim;
    }

    public boolean isBorderedNode() {
        int type = SiriusVisualIDRegistry.getVisualID(this.node.getType());
        boolean result = type == 3001 || type == 3012;
        return result;
    }

    public boolean isContainer() {
        int type = SiriusVisualIDRegistry.getVisualID(this.node.getType());
        boolean result = type == 3008 || type == 2002 || type == 3009 || type == 2003;
        return result;
    }

    public Option<Bounds> getExtendedBounds() {
        return this.getNewGMFBounds(false);
    }

    public Option<Bounds> getCollapsedBounds() {
        return this.getNewGMFBounds(true);
    }

    private Option<Bounds> getNewGMFBounds(boolean isCollapsed) {
        EObject element = this.node.getElement();
        LayoutConstraint layoutConstraint = this.node.getLayoutConstraint();
        if (element instanceof DDiagramElement && layoutConstraint instanceof Bounds) {
            CollapseFilter filter;
            Bounds bounds = (Bounds)layoutConstraint;
            Bounds newBounds = NotationFactory.eINSTANCE.createBounds();
            Dimension dim = isCollapsed ? this.getCollapsedSize() : ((filter = (CollapseFilter)Iterables.getFirst((Iterable)Iterables.filter((Iterable)((DDiagramElement)element).getGraphicalFilters(), (Predicate)Predicates.instanceOf(CollapseFilter.class)), null)) == null || filter.getWidth() == 0 || filter.getHeight() == 0 ? this.getDefaultDim((DDiagramElement)element) : new Dimension(filter.getWidth(), filter.getHeight()));
            Rectangle rect = null;
            Rectangle constraint = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
            Option<Rectangle> parentBorder = this.getParentBorder();
            if (parentBorder.some()) {
                constraint.translate(((Rectangle)parentBorder.get()).x, ((Rectangle)parentBorder.get()).y);
            }
            rect = isCollapsed ? PortLayoutHelper.getCollapseCandidateLocation(dim, constraint, (Rectangle)parentBorder.get()) : PortLayoutHelper.getUncollapseCandidateLocation(dim, constraint, (Rectangle)parentBorder.get());
            if (parentBorder.some()) {
                Dimension d = rect.getLocation().getDifference(((Rectangle)parentBorder.get()).getLocation());
                rect.setLocation(new Point(d.width, d.height));
            } else {
                rect.setLocation(rect.getLocation().getCopy());
            }
            newBounds.setHeight(rect.height);
            newBounds.setWidth(rect.width);
            newBounds.setX(rect.x);
            newBounds.setY(rect.y);
            return Options.newSome((Object)newBounds);
        }
        return Options.newNone();
    }

    private Option<Rectangle> getParentBorder() {
        EObject container = this.node.eContainer();
        if (container instanceof Node) {
            NodeQuery nodeQuery = new NodeQuery((Node)container);
            return Options.newSome((Object)nodeQuery.getHandleBounds());
        }
        return Options.newNone();
    }

    public Rectangle getHandleBounds() {
        return GMFHelper.getAbsoluteBounds(this.node, true, true);
    }

    public boolean isDescendantOf(View container) {
        boolean result = false;
        if (this.node.eContainer() instanceof Node && container instanceof Node && new NodeQuery((Node)container).isContainer()) {
            result = container.equals(this.node.eContainer()) ? true : new NodeQuery((Node)this.node.eContainer()).isDescendantOf(container);
        }
        return result;
    }
}

