/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.filters;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.filters.FiltersActivationAdapter;

public class FiltersContentProvider
implements IStructuredContentProvider {
    private FiltersActivationAdapter filtersActivationAdapter;
    private IDiagramWorkbenchPart diagramPart;

    public FiltersContentProvider(FiltersActivationAdapter adapter, IDiagramWorkbenchPart part) {
        this.filtersActivationAdapter = adapter;
        this.diagramPart = part;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof DiagramDescription) {
            DiagramDescription diagramDesc = (DiagramDescription)inputElement;
            return diagramDesc.getFilters().toArray();
        }
        return Collections.EMPTY_LIST.toArray();
    }

    public void dispose() {
        if (this.diagramPart != null) {
            DiagramEditPart diaEditPart = this.diagramPart.getDiagramEditPart();
            Object obj = diaEditPart.getModel();
            if (obj instanceof View) {
                this.removeListenerFrom((View)obj);
            }
            this.diagramPart = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Object obj;
        DiagramEditPart diaEditPart;
        if (oldInput != null) {
            this.filtersActivationAdapter.setViewer(viewer);
            diaEditPart = this.diagramPart.getDiagramEditPart();
            obj = diaEditPart.getModel();
            if (obj instanceof View) {
                this.removeListenerFrom((View)obj);
            }
        }
        if (newInput != null) {
            this.filtersActivationAdapter.setViewer(viewer);
            diaEditPart = this.diagramPart.getDiagramEditPart();
            obj = diaEditPart.getModel();
            if (obj instanceof View) {
                this.addListenerTo((View)obj);
            }
        }
    }

    private void removeListenerFrom(View oldInput) {
        EObject element = oldInput.getElement();
        if (element instanceof DDiagram) {
            DDiagram diagram = (DDiagram)element;
            diagram.eAdapters().remove((Object)this.filtersActivationAdapter);
        }
    }

    private void addListenerTo(View newInput) {
        EObject element = newInput.getElement();
        if (element instanceof DDiagram) {
            DDiagram diagram = (DDiagram)element;
            diagram.eAdapters().add((Object)this.filtersActivationAdapter);
        }
    }
}

