/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.LineIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class LinePrint
implements Print {
    final int orientation;
    double thickness;
    RGB rgb = new RGB(0, 0, 0);

    public LinePrint() {
        this(256);
    }

    public LinePrint(int orientation) {
        this(orientation, 1.0);
    }

    public LinePrint(int orientation, double thickness) {
        this.orientation = this.checkOrientation(orientation);
        this.thickness = this.checkThickness(thickness);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.orientation;
        result = 31 * result + (this.rgb == null ? 0 : this.rgb.hashCode());
        long temp = Double.doubleToLongBits(this.thickness);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinePrint other = (LinePrint)obj;
        if (this.orientation != other.orientation) {
            return false;
        }
        if (this.rgb == null ? other.rgb != null : !this.rgb.equals((Object)other.rgb)) {
            return false;
        }
        return Double.doubleToLongBits(this.thickness) == Double.doubleToLongBits(other.thickness);
    }

    public int getOrientation() {
        return this.orientation;
    }

    private int checkOrientation(int orientation) {
        if ((orientation & 0x100) == 256) {
            return 256;
        }
        if ((orientation & 0x200) == 512) {
            return 512;
        }
        return 256;
    }

    private double checkThickness(double thickness) {
        if (thickness < 0.0) {
            return 0.0;
        }
        return thickness;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public void setRGB(RGB foreground) {
        Util.notNull(foreground);
        this.rgb = foreground;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        return new LineIterator(this, device, gc);
    }
}

