/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ForwardingInputStream
extends InputStream {
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public ForwardingInputStream(InputStream theinputStream, OutputStream theoutputStream) {
        this.inputStream = theinputStream;
        this.outputStream = theoutputStream;
    }

    @Override
    public int read() throws IOException {
        int data = this.inputStream.read();
        if (data >= 0) {
            this.outputStream.write(data);
        }
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int count = this.inputStream.read(b);
        if (count > 0) {
            this.outputStream.write(b, 0, count);
        }
        return count;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.inputStream.read(b, off, len);
        if (count > 0) {
            this.outputStream.write(b, off, count);
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

