/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public abstract class AbstractOperandValidator {
    protected final RequestQuery requestQuery;
    protected final Operand currentOperand;
    protected Option<Operand> siblingOperandOption = Options.newNone();
    private Range initialOperandRange;
    private Range finalOperandRange;
    private Range initialSiblingOperandRange;
    private Range finalSiblingOperandRange;
    private boolean valid = true;
    private boolean initialized;

    public AbstractOperandValidator(Operand operand, RequestQuery requestQuery) {
        this.currentOperand = operand;
        this.requestQuery = requestQuery;
        this.valid = false;
        if (requestQuery.isResizeFromTop()) {
            this.siblingOperandOption = operand.getPreviousOperand();
        } else if (requestQuery.isResizeFromBottom()) {
            this.siblingOperandOption = operand.getFollowingOperand();
        }
    }

    public final boolean isValid() {
        if (!this.initialized) {
            this.validate();
            this.initialized = true;
        }
        return this.valid;
    }

    public Range getFinalRange() {
        return this.finalOperandRange;
    }

    protected void validate() {
        this.valid = this.checkAndComputeRanges();
        this.valid = this.valid && this.checkContainedISequenceEvent();
    }

    private boolean checkAndComputeRanges() {
        boolean result = true;
        this.initialOperandRange = this.currentOperand.getVerticalRange();
        Rectangle newBounds = this.getResizedBounds(new Rectangle(0, this.initialOperandRange.getLowerBound(), 0, this.initialOperandRange.width()));
        if (newBounds.height < 60) {
            result = false;
            this.finalOperandRange = RangeHelper.verticalRange((Rectangle)newBounds);
        } else {
            if (this.siblingOperandOption.some()) {
                Operand siblingOperand = (Operand)this.siblingOperandOption.get();
                this.initialSiblingOperandRange = siblingOperand.getVerticalRange();
                Rectangle siblingOperandNewBounds = this.getInverseResizedBounds(new Rectangle(0, this.initialSiblingOperandRange.getLowerBound(), 0, this.initialSiblingOperandRange.width()));
                if (siblingOperandNewBounds.height < 60) {
                    result = false;
                } else {
                    this.finalSiblingOperandRange = RangeHelper.verticalRange((Rectangle)siblingOperandNewBounds);
                }
            }
            this.finalOperandRange = RangeHelper.verticalRange((Rectangle)newBounds);
        }
        return result;
    }

    private boolean checkContainedISequenceEvent() {
        boolean result = this.finalOperandRange.includes(this.currentOperand.getOccupiedRange().grown(5));
        if (this.siblingOperandOption.some()) {
            result = result && this.finalSiblingOperandRange.includes(((Operand)this.siblingOperandOption.get()).getOccupiedRange().grown(5));
        }
        return result;
    }

    private Rectangle getResizedBounds(Rectangle bounds) {
        return this.requestQuery.getLogicalTransformedRectangle(bounds);
    }

    private Rectangle getInverseResizedBounds(Rectangle bounds) {
        Rectangle logicalDelta = this.requestQuery.getLogicalDelta();
        Point moveDelta = new Point();
        Dimension sizeDelta = logicalDelta.getSize().getCopy().getNegated();
        if (this.requestQuery.isResizeFromBottom()) {
            Dimension size = logicalDelta.getSize().getCopy();
            moveDelta = new Point(size.width, size.height);
        }
        return bounds.getCopy().translate(moveDelta).resize(sizeDelta);
    }

    public RequestQuery getRequestQuery() {
        return this.requestQuery;
    }
}

