/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.api.interpreter.IConverter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.TypedValidation;
import org.eclipse.sirius.common.tools.api.interpreter.VariableManager;
import org.eclipse.sirius.common.tools.internal.interpreter.DefaultConverter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public abstract class AbstractInterpreter
implements IInterpreter,
TypedValidation {
    protected static final String SEPARATOR = ".";
    protected VariableManager variables;
    private final IConverter converter = new DefaultConverter();

    protected AbstractInterpreter() {
        this.variables = new VariableManager();
    }

    @Override
    public IConverter getConverter() {
        return this.converter;
    }

    @Override
    public boolean provides(String expression) {
        return expression != null && expression.startsWith(this.getPrefix());
    }

    @Override
    public void clearImports() {
    }

    @Override
    public void addImport(String dependency) {
    }

    @Override
    public void setProperty(Object key, Object value) {
    }

    @Override
    public void setVariable(String name, Object value) {
        this.variables.setVariable(name, value);
    }

    @Override
    public void unSetVariable(String name) {
        this.variables.unSetVariable(name);
    }

    @Override
    public Object getVariable(String name) {
        return this.variables.getVariable(name);
    }

    public Map<String, Object> getVariables() {
        return this.variables.getVariables();
    }

    @Override
    public void clearVariables() {
        this.variables.clearVariables();
    }

    @Override
    public void dispose() {
        this.variables.clearVariables();
    }

    @Override
    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    @Override
    public String getVariablePrefix() {
        return "";
    }

    @Override
    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
    }

    @Override
    public Collection<String> getImports() {
        return Collections.emptySet();
    }

    @Override
    public void removeImport(String dependency) {
    }

    @Override
    public boolean supportsValidation() {
        return false;
    }

    @Override
    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return this.analyzeExpression(context, expression).getStatuses();
    }

    @Override
    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
    }
}

