/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.workspace.internal.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypeCustomizer;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypeProvider;
import org.eclipse.sirius.services.graphql.workspace.internal.SiriusGraphQLWorkspacePlugin;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ContainerResourcesField;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ResourceContainerField;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ResourceNameField;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ResourcePathField;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ResourceProjectField;

public class ProjectTypeProvider
implements ISiriusGraphQLTypeProvider {
    private static final String DESCRIPTION_FIELD = "description";
    private static final String RESOURCE_BY_PATH_FIELD = "resourceByPath";
    private static final String PATH_ARG = "path";

    public GraphQLType getType(ISiriusGraphQLTypeCustomizer customizer) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Project").field(ResourceNameField.build()).field(ResourcePathField.build()).field(ResourceContainerField.build()).field(ResourceProjectField.build()).field(ContainerResourcesField.build()).field(this.getDescriptionField()).field(this.getResourceByPathField()).withInterface(new GraphQLTypeReference("Resource")).withInterface(new GraphQLTypeReference("Container"));
        GraphQLObjectType.Builder customizedBuilder = customizer.customize("Project", builder);
        return customizedBuilder.build();
    }

    private GraphQLFieldDefinition getDescriptionField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(DESCRIPTION_FIELD).type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(this.getDescriptionDataFetcher()).build();
    }

    private DataFetcher<String> getDescriptionDataFetcher() {
        return environment -> {
            String description = null;
            Object source = environment.getSource();
            if (source instanceof IProject) {
                IProject iProject = (IProject)source;
                try {
                    IProjectDescription projectDescription = iProject.getDescription();
                    description = projectDescription.getComment();
                }
                catch (CoreException exception) {
                    Status status = new Status(4, "org.eclipse.sirius.services.graphql.workspace", exception.getMessage(), (Throwable)exception);
                    SiriusGraphQLWorkspacePlugin.getPlugin().log(status);
                }
            }
            return description;
        };
    }

    private GraphQLFieldDefinition getResourceByPathField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(RESOURCE_BY_PATH_FIELD).argument(this.getResourceByPathPathArg()).type((GraphQLOutputType)new GraphQLTypeReference("Resource")).dataFetcher(this.getResourcebyPathDataFetcher()).build();
    }

    private GraphQLArgument getResourceByPathPathArg() {
        return GraphQLArgument.newArgument().name(PATH_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private DataFetcher<IResource> getResourcebyPathDataFetcher() {
        return environment -> {
            Object source = environment.getSource();
            Object pathArg = environment.getArgument(PATH_ARG);
            if (source instanceof IProject && pathArg instanceof String) {
                IProject iProject = (IProject)source;
                String path = (String)pathArg;
                return iProject.findMember(path);
            }
            return null;
        };
    }
}

