/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.internal.actions;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.services.diagram.api.AbstractSiriusDiagramAction;
import org.eclipse.sirius.services.diagram.api.SiriusDiagramMessage;
import org.eclipse.sirius.services.diagram.api.SiriusDiagramService;
import org.eclipse.sirius.services.diagram.api.actions.SiriusDiagramRequestToolsAction;
import org.eclipse.sirius.services.diagram.api.actions.SiriusDiagramSetToolsAction;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramTool;
import org.eclipse.sirius.services.diagram.internal.actions.ISiriusDiagramActionHandler;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class SiriusDiagramRequestToolsActionHandler
implements ISiriusDiagramActionHandler {
    @Override
    public boolean canHandle(SiriusDiagramService diagramService, AbstractSiriusDiagramAction action) {
        return action instanceof SiriusDiagramRequestToolsAction;
    }

    @Override
    public void handle(SiriusDiagramService diagramService, AbstractSiriusDiagramAction action) {
        DDiagram dDiagram = diagramService.getDDiagram();
        List<SiriusDiagramTool> tools = dDiagram.getActivatedLayers().stream().map(Layer::getAllTools).flatMap(Collection::stream).map(this::createDiagramTool).collect(Collectors.toList());
        SiriusDiagramMessage message = new SiriusDiagramMessage();
        message.setAction(new SiriusDiagramSetToolsAction(tools));
        diagramService.dispatch(message);
    }

    private SiriusDiagramTool createDiagramTool(AbstractToolDescription toolDescription) {
        String type = this.getType(toolDescription);
        return new SiriusDiagramTool(toolDescription.getName(), toolDescription.getLabel(), type);
    }

    private String getType(AbstractToolDescription toolDescription) {
        String type = "nodeCreation";
        if (toolDescription instanceof ContainerCreationDescription || toolDescription instanceof NodeCreationDescription) {
            type = "nodeCreation";
        }
        return type;
    }
}

