/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal.services.workflow;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;

public class SiriusToolServices {
    public EObject executeOperation(EObject eObject, String initialCommandUri) {
        ModelOperation modelOperation;
        Session session;
        if (!eObject.eIsProxy() && (session = new EObjectQuery(eObject).getSession()) != null && (modelOperation = this.findModelOperation(initialCommandUri, session)) != null) {
            ModelAccessor modelAccessor = session.getModelAccessor();
            ICommandTask task = new TaskHelper(modelAccessor, SiriusPlugin.getDefault().getUiCallback()).buildTaskFromModelOperation(eObject, modelOperation);
            SiriusCommand command = new SiriusCommand(session.getTransactionalEditingDomain(), "SiriusToolServices#executeOperation");
            command.getTasks().add(task);
            try {
                try {
                    if (command.canExecute()) {
                        command.execute();
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    command.dispose();
                }
            }
            finally {
                command.dispose();
            }
        }
        return eObject;
    }

    private ModelOperation findModelOperation(String initialCommandUri, Session session) {
        URI commandResourceURI = URI.createURI((String)initialCommandUri).trimFragment();
        for (Resource res : this.getResourcesInScope(session)) {
            EObject modelOperationEObject;
            if (!commandResourceURI.equals(res.getURI()) || !((modelOperationEObject = res.getEObject(URI.createURI((String)initialCommandUri).fragment())) instanceof InitialOperation)) continue;
            return ((InitialOperation)modelOperationEObject).getFirstModelOperations();
        }
        return null;
    }

    private Set<Resource> getResourcesInScope(Session session) {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        Collection selectedViewpoints = session.getSelectedViewpoints(true);
        for (Viewpoint viewpoint : selectedViewpoints) {
            Resource eResource = viewpoint.eResource();
            if (eResource == null) continue;
            result.add(eResource);
        }
        return result;
    }
}

