/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearch;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class LDIFLDAPSearchOutputHandler
extends LDAPSearchOutputHandler {
    private final ArrayList<String> formattedLines;
    private final int maxWidth;
    private final LDAPSearch ldapSearch;
    private final StringBuilder formattedLineBuffer;

    LDIFLDAPSearchOutputHandler(LDAPSearch ldapSearch, int maxWidth) {
        this.ldapSearch = ldapSearch;
        this.maxWidth = maxWidth;
        this.formattedLines = new ArrayList(20);
        this.formattedLineBuffer = new StringBuilder(100);
    }

    @Override
    public void formatHeader() {
    }

    @Override
    public void formatSearchResultEntry(SearchResultEntry entry) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatSearchResultEntry(this.formattedLines, entry, this.maxWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }

    @Override
    public void formatSearchResultReference(SearchResultReference ref) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatSearchResultReference(this.formattedLines, ref, this.maxWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }

    @Override
    public void formatResult(LDAPResult result) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatResult(this.formattedLines, result, true, false, 0, this.maxWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }

    @Override
    public void formatUnsolicitedNotification(LDAPConnection connection, ExtendedResult notification) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatUnsolicitedNotification(this.formattedLines, notification, true, 0, this.maxWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }
}

