/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util.sec.security.provider;

import com.sun.ts.lib.util.sec.misc.JavaSecurityProtectionDomainAccess;
import com.sun.ts.lib.util.sec.misc.SharedSecrets;
import com.sun.ts.lib.util.sec.net.www.ParseUtil;
import com.sun.ts.lib.util.sec.security.auth.PrincipalComparator;
import com.sun.ts.lib.util.sec.security.provider.IdentityDatabase;
import com.sun.ts.lib.util.sec.security.provider.PolicyParser;
import com.sun.ts.lib.util.sec.security.provider.SystemIdentity;
import com.sun.ts.lib.util.sec.security.provider.SystemSigner;
import com.sun.ts.lib.util.sec.security.util.Debug;
import com.sun.ts.lib.util.sec.security.util.PolicyUtil;
import com.sun.ts.lib.util.sec.security.util.PropertyExpander;
import com.sun.ts.lib.util.sec.security.util.ResourcesMgr;
import com.sun.ts.lib.util.sec.security.util.SecurityConstants;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;

public class PolicyFile
extends Policy {
    private static final Debug debug = Debug.getInstance("policy");
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String SELF = "${{self}}";
    private static final String X500PRINCIPAL = "javax.security.auth.x500.X500Principal";
    private static final String POLICY = "java.security.policy";
    private static final String SECURITY_MANAGER = "java.security.manager";
    private static final String POLICY_URL = "policy.url.";
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private static final int DEFAULT_CACHE_SIZE = 1;
    private static IdentityScope scope = null;
    private AtomicReference<PolicyInfo> policyInfo = new AtomicReference();
    private boolean constructed = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = false;
    private boolean allowSystemProperties = true;
    private boolean notUtf8 = false;
    private URL url;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};

    public PolicyFile() {
        this.init(null);
    }

    public PolicyFile(URL url) {
        this.url = url;
        this.init(url);
    }

    private void init(URL url) {
        int numCaches;
        String numCacheStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                PolicyFile.this.expandProperties = "true".equalsIgnoreCase(Security.getProperty("policy.expandProperties"));
                PolicyFile.this.ignoreIdentityScope = "true".equalsIgnoreCase(Security.getProperty("policy.ignoreIdentityScope"));
                PolicyFile.this.allowSystemProperties = "true".equalsIgnoreCase(Security.getProperty("policy.allowSystemProperty"));
                PolicyFile.this.notUtf8 = "false".equalsIgnoreCase(System.getProperty("sun.security.policy.utf8"));
                return System.getProperty("sun.security.policy.numcaches");
            }
        });
        if (numCacheStr != null) {
            try {
                numCaches = Integer.parseInt(numCacheStr);
            }
            catch (NumberFormatException e) {
                numCaches = 1;
            }
        } else {
            numCaches = 1;
        }
        PolicyInfo newInfo = new PolicyInfo(numCaches);
        this.initPolicyFile(newInfo, url);
        this.policyInfo.set(newInfo);
    }

    private void initPolicyFile(final PolicyInfo newInfo, final URL url) {
        if (url != null) {
            if (debug != null) {
                debug.println("reading " + String.valueOf(url));
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (!PolicyFile.this.init(url, newInfo)) {
                        PolicyFile.this.initStaticPolicy(newInfo);
                    }
                    return null;
                }
            });
        } else {
            boolean loaded_one = this.initPolicyFile(POLICY, POLICY_URL, newInfo);
            if (!loaded_one) {
                this.initStaticPolicy(newInfo);
            }
            this.initPolicyFile(AUTH_POLICY, AUTH_POLICY_URL, newInfo);
        }
    }

    private boolean initPolicyFile(final String propname, final String urlname, final PolicyInfo newInfo) {
        Boolean loadedPolicy = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String policy_uri;
                String extra_policy;
                boolean loaded_policy = false;
                if (PolicyFile.this.allowSystemProperties && (extra_policy = System.getProperty(propname)) != null) {
                    boolean overrideAll;
                    block13: {
                        overrideAll = false;
                        if (extra_policy.startsWith("=")) {
                            overrideAll = true;
                            extra_policy = extra_policy.substring(1);
                        }
                        try {
                            extra_policy = PropertyExpander.expand(extra_policy);
                            File policyFile = new File(extra_policy);
                            URL policyURL = policyFile.exists() ? ParseUtil.fileToEncodedURL(new File(policyFile.getCanonicalPath())) : new URL(extra_policy);
                            if (debug != null) {
                                debug.println("reading " + String.valueOf(policyURL));
                            }
                            if (PolicyFile.this.init(policyURL, newInfo)) {
                                loaded_policy = true;
                            }
                        }
                        catch (Exception e) {
                            if (debug == null) break block13;
                            debug.println("caught exception: " + String.valueOf(e));
                        }
                    }
                    if (overrideAll) {
                        if (debug != null) {
                            debug.println("overriding other policies!");
                        }
                        return loaded_policy;
                    }
                }
                int n = 1;
                while ((policy_uri = Security.getProperty(urlname + n)) != null) {
                    block14: {
                        try {
                            URL policy_url = null;
                            String expanded_uri = PropertyExpander.expand(policy_uri).replace(File.separatorChar, '/');
                            policy_url = policy_uri.startsWith("file:${java.home}/") || policy_uri.startsWith("file:${user.home}/") ? new File(expanded_uri.substring(5)).toURI().toURL() : new URI(expanded_uri).toURL();
                            if (debug != null) {
                                debug.println("reading " + String.valueOf(policy_url));
                            }
                            if (PolicyFile.this.init(policy_url, newInfo)) {
                                loaded_policy = true;
                            }
                        }
                        catch (Exception e) {
                            if (debug == null) break block14;
                            debug.println("error reading policy " + String.valueOf(e));
                            e.printStackTrace();
                        }
                    }
                    ++n;
                }
                return loaded_policy;
            }
        });
        return loadedPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init(URL policy, PolicyInfo newInfo) {
        boolean success = false;
        PolicyParser pp = new PolicyParser(this.expandProperties);
        InputStreamReader isr = null;
        try {
            KeyStore keyStore;
            block22: {
                isr = this.notUtf8 ? new InputStreamReader(PolicyUtil.getInputStream(policy)) : new InputStreamReader(PolicyUtil.getInputStream(policy), "UTF-8");
                pp.read(isr);
                keyStore = null;
                try {
                    keyStore = PolicyUtil.getKeyStore(policy, pp.getKeyStoreUrl(), pp.getKeyStoreType(), pp.getKeyStoreProvider(), pp.getStorePassURL(), debug);
                }
                catch (Exception e) {
                    if (debug == null) break block22;
                    e.printStackTrace();
                }
            }
            Enumeration<PolicyParser.GrantEntry> enum_ = pp.grantElements();
            while (enum_.hasMoreElements()) {
                PolicyParser.GrantEntry ge = enum_.nextElement();
                this.addGrantEntry(ge, keyStore, newInfo);
            }
        }
        catch (PolicyParser.ParsingException pe) {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("java.security.policy: error parsing policy:\n\tmessage"));
            Object[] source = new Object[]{policy, pe.getLocalizedMessage()};
            System.err.println(form.format(source));
            if (debug != null) {
                pe.printStackTrace();
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("error parsing " + String.valueOf(policy));
                debug.println(e.toString());
                e.printStackTrace();
            }
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                    success = true;
                }
                catch (IOException pe) {}
            } else {
                success = true;
            }
        }
        return success;
    }

    private void initStaticPolicy(final PolicyInfo newInfo) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PolicyEntry pe = new PolicyEntry(new CodeSource(null, (Certificate[])null));
                pe.add(SecurityConstants.LOCAL_LISTEN_PERMISSION);
                pe.add(new PropertyPermission("java.version", "read"));
                pe.add(new PropertyPermission("java.vendor", "read"));
                pe.add(new PropertyPermission("java.vendor.url", "read"));
                pe.add(new PropertyPermission("java.class.version", "read"));
                pe.add(new PropertyPermission("os.name", "read"));
                pe.add(new PropertyPermission("os.version", "read"));
                pe.add(new PropertyPermission("os.arch", "read"));
                pe.add(new PropertyPermission("file.separator", "read"));
                pe.add(new PropertyPermission("path.separator", "read"));
                pe.add(new PropertyPermission("line.separator", "read"));
                pe.add(new PropertyPermission("java.specification.version", "read"));
                pe.add(new PropertyPermission("java.specification.vendor", "read"));
                pe.add(new PropertyPermission("java.specification.name", "read"));
                pe.add(new PropertyPermission("java.vm.specification.version", "read"));
                pe.add(new PropertyPermission("java.vm.specification.vendor", "read"));
                pe.add(new PropertyPermission("java.vm.specification.name", "read"));
                pe.add(new PropertyPermission("java.vm.version", "read"));
                pe.add(new PropertyPermission("java.vm.vendor", "read"));
                pe.add(new PropertyPermission("java.vm.name", "read"));
                newInfo.policyEntries.add(pe);
                return null;
            }
        });
    }

    private CodeSource getCodeSource(PolicyParser.GrantEntry ge, KeyStore keyStore, PolicyInfo newInfo) throws MalformedURLException {
        Certificate[] certs = null;
        if (ge.signedBy != null && (certs = this.getCertificates(keyStore, ge.signedBy, newInfo)) == null) {
            if (debug != null) {
                debug.println("  -- No certs for alias '" + ge.signedBy + "' - ignoring entry");
            }
            return null;
        }
        URL location = ge.codeBase != null ? new URL(ge.codeBase) : null;
        return this.canonicalizeCodebase(new CodeSource(location, certs), false);
    }

    private void addGrantEntry(PolicyParser.GrantEntry ge, KeyStore keyStore, PolicyInfo newInfo) {
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + ge.signedBy);
            debug.println("  codeBase " + ge.codeBase);
            if (ge.principals != null && ge.principals.size() > 0) {
                ListIterator li = ge.principals.listIterator();
                while (li.hasNext()) {
                    PolicyParser.PrincipalEntry pppe = (PolicyParser.PrincipalEntry)li.next();
                    debug.println("  " + pppe.toString());
                }
            }
        }
        try {
            CodeSource codesource = this.getCodeSource(ge, keyStore, newInfo);
            if (codesource == null) {
                return;
            }
            if (!this.replacePrincipals(ge.principals, keyStore)) {
                return;
            }
            PolicyEntry entry = new PolicyEntry(codesource, ge.principals);
            Enumeration<PolicyParser.PermissionEntry> enum_ = ge.permissionElements();
            while (enum_.hasMoreElements()) {
                Object[] source;
                MessageFormat form;
                Object certs;
                PolicyParser.PermissionEntry pe = enum_.nextElement();
                try {
                    Permission perm;
                    this.expandPermissionName(pe, keyStore);
                    if (pe.permission.equals("javax.security.auth.PrivateCredentialPermission") && pe.name.endsWith(" self")) {
                        pe.name = pe.name.substring(0, pe.name.indexOf("self")) + SELF;
                    }
                    if (pe.name != null && pe.name.indexOf(SELF) != -1) {
                        certs = pe.signedBy != null ? this.getCertificates(keyStore, pe.signedBy, newInfo) : null;
                        perm = new SelfPermission(pe.permission, pe.name, pe.action, (Certificate[])certs);
                    } else {
                        perm = PolicyFile.getInstance(pe.permission, pe.name, pe.action);
                    }
                    entry.add(perm);
                    if (debug == null) continue;
                    debug.println("  " + String.valueOf(perm));
                }
                catch (ClassNotFoundException cnfe) {
                    certs = pe.signedBy != null ? this.getCertificates(keyStore, pe.signedBy, newInfo) : null;
                    if (certs == null && pe.signedBy != null) continue;
                    UnresolvedPermission perm = new UnresolvedPermission(pe.permission, pe.name, pe.action, (Certificate[])certs);
                    entry.add(perm);
                    if (debug == null) continue;
                    debug.println("  " + String.valueOf(perm));
                }
                catch (InvocationTargetException ite) {
                    form = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Permission, perm:\n\tmessage"));
                    source = new Object[]{pe.permission, ite.getTargetException().toString()};
                    System.err.println(form.format(source));
                }
                catch (Exception e) {
                    form = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Permission, perm:\n\tmessage"));
                    source = new Object[]{pe.permission, e.toString()};
                    System.err.println(form.format(source));
                }
            }
            newInfo.policyEntries.add(entry);
        }
        catch (Exception e) {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Entry:\n\tmessage"));
            Object[] source = new Object[]{e.toString()};
            System.err.println(form.format(source));
        }
        if (debug != null) {
            debug.println();
        }
    }

    private static final Permission getInstance(String type, String name, String actions) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> pc = Class.forName(type);
        Permission answer = PolicyFile.getKnownInstance(pc, name, actions);
        if (answer != null) {
            return answer;
        }
        if (name == null && actions == null) {
            try {
                Constructor<?> c = pc.getConstructor(PARAMS0);
                return (Permission)c.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException ne) {
                try {
                    Constructor<?> c = pc.getConstructor(PARAMS1);
                    return (Permission)c.newInstance(name);
                }
                catch (NoSuchMethodException ne1) {
                    Constructor<?> c = pc.getConstructor(PARAMS2);
                    return (Permission)c.newInstance(name, actions);
                }
            }
        }
        if (name != null && actions == null) {
            try {
                Constructor<?> c = pc.getConstructor(PARAMS1);
                return (Permission)c.newInstance(name);
            }
            catch (NoSuchMethodException ne) {
                Constructor<?> c = pc.getConstructor(PARAMS2);
                return (Permission)c.newInstance(name, actions);
            }
        }
        Constructor<?> c = pc.getConstructor(PARAMS2);
        return (Permission)c.newInstance(name, actions);
    }

    private static final Permission getKnownInstance(Class claz, String name, String actions) {
        if (claz.equals(FilePermission.class)) {
            return new FilePermission(name, actions);
        }
        if (claz.equals(SocketPermission.class)) {
            return new SocketPermission(name, actions);
        }
        if (claz.equals(RuntimePermission.class)) {
            return new RuntimePermission(name, actions);
        }
        if (claz.equals(PropertyPermission.class)) {
            return new PropertyPermission(name, actions);
        }
        if (claz.equals(NetPermission.class)) {
            return new NetPermission(name, actions);
        }
        if (claz.equals(AllPermission.class)) {
            return SecurityConstants.ALL_PERMISSION;
        }
        if (claz.equals(AWTPermission.class)) {
            return new AWTPermission(name, actions);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] getCertificates(KeyStore keyStore, String aliases, PolicyInfo newInfo) {
        ArrayList<Certificate> vcerts = null;
        StringTokenizer st = new StringTokenizer(aliases, ",");
        int n = 0;
        while (st.hasMoreTokens()) {
            String alias = st.nextToken().trim();
            ++n;
            Certificate cert = null;
            Map map = newInfo.aliasMapping;
            synchronized (map) {
                cert = (Certificate)newInfo.aliasMapping.get(alias);
                if (cert == null && keyStore != null) {
                    try {
                        cert = keyStore.getCertificate(alias);
                    }
                    catch (KeyStoreException keyStoreException) {
                        // empty catch block
                    }
                    if (cert != null) {
                        newInfo.aliasMapping.put(alias, cert);
                        newInfo.aliasMapping.put(cert, alias);
                    }
                }
            }
            if (cert == null) continue;
            if (vcerts == null) {
                vcerts = new ArrayList<Certificate>();
            }
            vcerts.add(cert);
        }
        if (vcerts != null && n == vcerts.size()) {
            Certificate[] certs = new Certificate[vcerts.size()];
            vcerts.toArray(certs);
            return certs;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.init(this.url);
    }

    @Override
    public boolean implies(ProtectionDomain pd, Permission p) {
        PolicyInfo pi = this.policyInfo.get();
        JavaSecurityProtectionDomainAccess.ProtectionDomainCache pdMap = pi.getPdMapping();
        PermissionCollection pc = pdMap.get(pd);
        if (pc != null) {
            return pc.implies(p);
        }
        pc = this.getPermissions(pd);
        if (pc == null) {
            return false;
        }
        pdMap.put(pd, pc);
        return pc.implies(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions perms = new Permissions();
        if (domain == null) {
            return perms;
        }
        this.getPermissions(perms, domain);
        PermissionCollection pc = domain.getPermissions();
        if (pc != null) {
            PermissionCollection permissionCollection = pc;
            synchronized (permissionCollection) {
                Enumeration<Permission> e = pc.elements();
                while (e.hasMoreElements()) {
                    perms.add(e.nextElement());
                }
            }
        }
        return perms;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        return this.getPermissions(new Permissions(), codesource);
    }

    private PermissionCollection getPermissions(Permissions perms, ProtectionDomain pd) {
        CodeSource cs;
        if (debug != null) {
            debug.println("getPermissions:\n\t" + this.printPD(pd));
        }
        if ((cs = pd.getCodeSource()) == null) {
            return perms;
        }
        CodeSource canonCodeSource = AccessController.doPrivileged(new PrivilegedAction<CodeSource>(){

            @Override
            public CodeSource run() {
                return PolicyFile.this.canonicalizeCodebase(cs, true);
            }
        });
        return this.getPermissions(perms, canonCodeSource, pd.getPrincipals());
    }

    private PermissionCollection getPermissions(Permissions perms, final CodeSource cs) {
        CodeSource canonCodeSource = AccessController.doPrivileged(new PrivilegedAction<CodeSource>(){

            @Override
            public CodeSource run() {
                return PolicyFile.this.canonicalizeCodebase(cs, true);
            }
        });
        return this.getPermissions(perms, canonCodeSource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Permissions getPermissions(Permissions perms, CodeSource cs, Principal[] principals) {
        Certificate[] certs;
        PolicyInfo pi = this.policyInfo.get();
        for (PolicyEntry policyEntry : pi.policyEntries) {
            this.addPermissions(perms, cs, principals, policyEntry);
        }
        List<PolicyEntry> list = pi.identityPolicyEntries;
        synchronized (list) {
            for (PolicyEntry entry : pi.identityPolicyEntries) {
                this.addPermissions(perms, cs, principals, entry);
            }
        }
        if (!this.ignoreIdentityScope && (certs = cs.getCertificates()) != null) {
            void var6_9;
            boolean bl = false;
            while (var6_9 < certs.length) {
                Object idMap = pi.aliasMapping.get(certs[var6_9]);
                if (idMap == null && this.checkForTrustedIdentity(certs[var6_9], pi)) {
                    perms.add(SecurityConstants.ALL_PERMISSION);
                }
                ++var6_9;
            }
        }
        return perms;
    }

    private void addPermissions(Permissions perms, final CodeSource cs, Principal[] principals, final PolicyEntry entry) {
        Boolean imp;
        if (debug != null) {
            debug.println("evaluate codesources:\n\tPolicy CodeSource: " + String.valueOf(entry.getCodeSource()) + "\n\tActive CodeSource: " + String.valueOf(cs));
        }
        if (!(imp = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return new Boolean(entry.getCodeSource().implies(cs));
            }
        })).booleanValue()) {
            if (debug != null) {
                debug.println("evaluation (codesource) failed");
            }
            return;
        }
        List<PolicyParser.PrincipalEntry> entryPs = entry.getPrincipals();
        if (debug != null) {
            ArrayList<PolicyParser.PrincipalEntry> accPs = new ArrayList<PolicyParser.PrincipalEntry>();
            if (principals != null) {
                for (int i = 0; i < principals.length; ++i) {
                    accPs.add(new PolicyParser.PrincipalEntry(principals[i].getClass().getName(), principals[i].getName()));
                }
            }
            debug.println("evaluate principals:\n\tPolicy Principals: " + String.valueOf(entryPs) + "\n\tActive Principals: " + String.valueOf(accPs));
        }
        if (entryPs == null || entryPs.size() == 0) {
            this.addPerms(perms, principals, entry);
            if (debug != null) {
                debug.println("evaluation (codesource/principals) passed");
            }
            return;
        }
        if (principals == null || principals.length == 0) {
            if (debug != null) {
                debug.println("evaluation (principals) failed");
            }
            return;
        }
        for (int i = 0; i < entryPs.size(); ++i) {
            PolicyParser.PrincipalEntry pppe = entryPs.get(i);
            try {
                Class<?> pClass = Class.forName(pppe.principalClass, true, Thread.currentThread().getContextClassLoader());
                if (!PrincipalComparator.class.isAssignableFrom(pClass)) {
                    if (this.checkEntryPs(principals, pppe)) continue;
                    if (debug != null) {
                        debug.println("evaluation (principals) failed");
                    }
                    return;
                }
                Constructor<?> c = pClass.getConstructor(PARAMS1);
                PrincipalComparator pc = (PrincipalComparator)c.newInstance(pppe.principalName);
                if (debug != null) {
                    debug.println("found PrincipalComparator " + pc.getClass().getName());
                }
                HashSet<Principal> pSet = new HashSet<Principal>(principals.length);
                for (int j = 0; j < principals.length; ++j) {
                    pSet.add(principals[j]);
                }
                Subject subject = new Subject(true, pSet, Collections.EMPTY_SET, Collections.EMPTY_SET);
                if (pc.implies(subject)) continue;
                if (debug != null) {
                    debug.println("evaluation (principal comparator) failed");
                }
                return;
            }
            catch (Exception e) {
                if (debug != null) {
                    e.printStackTrace();
                }
                if (this.checkEntryPs(principals, pppe)) continue;
                if (debug != null) {
                    debug.println("evaluation (principals) failed");
                }
                return;
            }
        }
        if (debug != null) {
            debug.println("evaluation (codesource/principals) passed");
        }
        this.addPerms(perms, principals, entry);
    }

    private void addPerms(Permissions perms, Principal[] accPs, PolicyEntry entry) {
        for (int i = 0; i < entry.permissions.size(); ++i) {
            Permission p = entry.permissions.get(i);
            if (debug != null) {
                debug.println("  granting " + String.valueOf(p));
            }
            if (p instanceof SelfPermission) {
                this.expandSelf((SelfPermission)p, entry.getPrincipals(), accPs, perms);
                continue;
            }
            perms.add(p);
        }
    }

    private boolean checkEntryPs(Principal[] pList, PolicyParser.PrincipalEntry pppe) {
        for (int i = 0; i < pList.length; ++i) {
            if (!pppe.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !pppe.principalClass.equals(pList[i].getClass().getName()) || !pppe.principalName.equals("WILDCARD_PRINCIPAL_NAME") && !pppe.principalName.equals(pList[i].getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void expandSelf(SelfPermission sp, List<PolicyParser.PrincipalEntry> entryPs, Principal[] pdp, Permissions perms) {
        String[][] principalInfo;
        int v;
        if (entryPs == null || entryPs.size() == 0) {
            if (debug == null) return;
            debug.println("Ignoring permission " + sp.getSelfType() + " with target name (" + sp.getSelfName() + ").  No Principal(s) specified in the grant clause.  SELF-based target names are only valid in the context of a Principal-based grant entry.");
            return;
        }
        int startIndex = 0;
        StringBuilder sb = new StringBuilder();
        while ((v = sp.getSelfName().indexOf(SELF, startIndex)) != -1) {
            sb.append(sp.getSelfName().substring(startIndex, v));
            ListIterator<PolicyParser.PrincipalEntry> pli = entryPs.listIterator();
            while (pli.hasNext()) {
                PolicyParser.PrincipalEntry pppe = pli.next();
                principalInfo = this.getPrincipalInfo(pppe, pdp);
                for (int i = 0; i < principalInfo.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(principalInfo[i][0] + " \"" + principalInfo[i][1] + "\"");
                }
                if (!pli.hasNext()) continue;
                sb.append(", ");
            }
            startIndex = v + SELF.length();
        }
        sb.append(sp.getSelfName().substring(startIndex));
        if (debug != null) {
            debug.println("  expanded:\n\t" + sp.getSelfName() + "\n  into:\n\t" + sb.toString());
        }
        try {
            perms.add(PolicyFile.getInstance(sp.getSelfType(), sb.toString(), sp.getSelfActions()));
            return;
        }
        catch (ClassNotFoundException cnfe) {
            Class<?> pc = null;
            principalInfo = perms;
            synchronized (perms) {
                Enumeration<Permission> e = perms.elements();
                while (e.hasMoreElements()) {
                    Permission pElement = e.nextElement();
                    if (!pElement.getClass().getName().equals(sp.getSelfType())) continue;
                    pc = pElement.getClass();
                    break;
                }
                // ** MonitorExit[principalInfo] (shouldn't be in output)
                if (pc == null) {
                    perms.add(new UnresolvedPermission(sp.getSelfType(), sb.toString(), sp.getSelfActions(), sp.getCerts()));
                    return;
                }
                try {
                    Constructor<Object> c;
                    if (sp.getSelfActions() == null) {
                        try {
                            c = pc.getConstructor(PARAMS1);
                            perms.add((Permission)c.newInstance(sb.toString()));
                            return;
                        }
                        catch (NoSuchMethodException ne) {
                            c = pc.getConstructor(PARAMS2);
                            perms.add((Permission)c.newInstance(sb.toString(), sp.getSelfActions()));
                        }
                        return;
                    }
                    c = pc.getConstructor(PARAMS2);
                    perms.add((Permission)c.newInstance(sb.toString(), sp.getSelfActions()));
                    return;
                }
                catch (Exception nme) {
                    if (debug == null) return;
                    debug.println("self entry expansion  instantiation failed: " + nme.toString());
                }
                return;
            }
        }
        catch (Exception e) {
            if (debug == null) return;
            debug.println(e.toString());
        }
    }

    private String[][] getPrincipalInfo(PolicyParser.PrincipalEntry pe, Principal[] pdp) {
        if (!pe.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !pe.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] info = new String[1][2];
            info[0][0] = pe.principalClass;
            info[0][1] = pe.principalName;
            return info;
        }
        if (!pe.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && pe.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            ArrayList<Principal> plist = new ArrayList<Principal>();
            for (int i = 0; i < pdp.length; ++i) {
                if (!pe.principalClass.equals(pdp[i].getClass().getName())) continue;
                plist.add(pdp[i]);
            }
            String[][] info = new String[plist.size()][2];
            int i = 0;
            for (Principal p : plist) {
                info[i][0] = p.getClass().getName();
                info[i][1] = p.getName();
                ++i;
            }
            return info;
        }
        String[][] info = new String[pdp.length][2];
        for (int i = 0; i < pdp.length; ++i) {
            info[i][0] = pdp[i].getClass().getName();
            info[i][1] = pdp[i].getName();
        }
        return info;
    }

    protected Certificate[] getSignerCertificates(CodeSource cs) {
        int i;
        Certificate[] certs = null;
        certs = cs.getCertificates();
        if (certs == null) {
            return null;
        }
        for (i = 0; i < certs.length; ++i) {
            if (certs[i] instanceof X509Certificate) continue;
            return cs.getCertificates();
        }
        int count = 0;
        for (i = 0; i < certs.length; ++i) {
            ++count;
            while (i + 1 < certs.length && ((X509Certificate)certs[i]).getIssuerDN().equals(((X509Certificate)certs[i + 1]).getSubjectDN())) {
                ++i;
            }
        }
        if (count == certs.length) {
            return certs;
        }
        ArrayList<Certificate> userCertList = new ArrayList<Certificate>();
        for (i = 0; i < certs.length; ++i) {
            userCertList.add(certs[i]);
            while (i + 1 < certs.length && ((X509Certificate)certs[i]).getIssuerDN().equals(((X509Certificate)certs[i + 1]).getSubjectDN())) {
                ++i;
            }
        }
        Certificate[] userCerts = new Certificate[userCertList.size()];
        userCertList.toArray(userCerts);
        return userCerts;
    }

    private CodeSource canonicalizeCodebase(CodeSource cs, boolean extractSignerCerts) {
        CodeSource canonCs;
        block8: {
            String path = null;
            canonCs = cs;
            URL u = cs.getLocation();
            if (u != null && u.getProtocol().equals("file")) {
                boolean isLocalFile = false;
                String host = u.getHost();
                boolean bl = isLocalFile = host == null || host.equals("") || host.equals("~") || host.equalsIgnoreCase("localhost");
                if (isLocalFile) {
                    path = u.getFile().replace('/', File.separatorChar);
                    path = ParseUtil.decode(path);
                }
            }
            if (path != null) {
                try {
                    URL csUrl = null;
                    path = PolicyFile.canonPath(path);
                    csUrl = ParseUtil.fileToEncodedURL(new File(path));
                    if (extractSignerCerts) {
                        canonCs = new CodeSource(csUrl, this.getSignerCertificates(cs));
                        break block8;
                    }
                    canonCs = new CodeSource(csUrl, cs.getCertificates());
                }
                catch (IOException ioe) {
                    if (extractSignerCerts) {
                        canonCs = new CodeSource(cs.getLocation(), this.getSignerCertificates(cs));
                    }
                    break block8;
                }
            }
            if (extractSignerCerts) {
                canonCs = new CodeSource(cs.getLocation(), this.getSignerCertificates(cs));
            }
        }
        return canonCs;
    }

    public static String canonPath(String path) throws IOException {
        if (((String)path).endsWith("*")) {
            path = ((String)path).substring(0, ((String)path).length() - 1) + "-";
            path = new File((String)path).getCanonicalPath();
            return ((String)path).substring(0, ((String)path).length() - 1) + "*";
        }
        return new File((String)path).getCanonicalPath();
    }

    private String printPD(ProtectionDomain pd) {
        Principal[] principals = pd.getPrincipals();
        String pals = "<no principals>";
        if (principals != null && principals.length > 0) {
            StringBuilder palBuf = new StringBuilder("(principals ");
            for (int i = 0; i < principals.length; ++i) {
                palBuf.append(principals[i].getClass().getName() + " \"" + principals[i].getName() + "\"");
                if (i < principals.length - 1) {
                    palBuf.append(", ");
                    continue;
                }
                palBuf.append(")");
            }
            pals = palBuf.toString();
        }
        return "PD CodeSource: " + String.valueOf(pd.getCodeSource()) + "\n\tPD ClassLoader: " + String.valueOf(pd.getClassLoader()) + "\n\tPD Principals: " + pals;
    }

    private boolean replacePrincipals(List<PolicyParser.PrincipalEntry> principals, KeyStore keystore) {
        if (principals == null || principals.size() == 0 || keystore == null) {
            return true;
        }
        ListIterator<PolicyParser.PrincipalEntry> i = principals.listIterator();
        while (i.hasNext()) {
            PolicyParser.PrincipalEntry pppe = i.next();
            if (!pppe.principalClass.equals("PolicyParser.REPLACE_NAME")) continue;
            String name = this.getDN(pppe.principalName, keystore);
            if (name == null) {
                return false;
            }
            if (debug != null) {
                debug.println("  Replacing \"" + pppe.principalName + "\" with javax.security.auth.x500.X500Principal/\"" + name + "\"");
            }
            pppe.principalClass = X500PRINCIPAL;
            pppe.principalName = name;
        }
        return true;
    }

    private void expandPermissionName(PolicyParser.PermissionEntry pe, KeyStore keystore) throws Exception {
        int e;
        int b;
        if (pe.name == null || pe.name.indexOf("${{", 0) == -1) {
            return;
        }
        int startIndex = 0;
        StringBuilder sb = new StringBuilder();
        while ((b = pe.name.indexOf("${{", startIndex)) != -1 && (e = pe.name.indexOf("}}", b)) >= 1) {
            String value;
            sb.append(pe.name.substring(startIndex, b));
            String prefix = value = pe.name.substring(b + 3, e);
            int colonIndex = value.indexOf(":");
            if (colonIndex != -1) {
                prefix = value.substring(0, colonIndex);
            }
            if (prefix.equalsIgnoreCase("self")) {
                sb.append(pe.name.substring(b, e + 2));
                startIndex = e + 2;
                continue;
            }
            if (prefix.equalsIgnoreCase("alias")) {
                if (colonIndex == -1) {
                    MessageFormat form = new MessageFormat(ResourcesMgr.getString("alias name not provided (pe.name)"));
                    Object[] source = new Object[]{pe.name};
                    throw new Exception(form.format(source));
                }
                String suffix = value.substring(colonIndex + 1);
                if ((suffix = this.getDN(suffix, keystore)) == null) {
                    MessageFormat form = new MessageFormat(ResourcesMgr.getString("unable to perform substitution on alias, suffix"));
                    Object[] source = new Object[]{value.substring(colonIndex + 1)};
                    throw new Exception(form.format(source));
                }
                sb.append("javax.security.auth.x500.X500Principal \"" + suffix + "\"");
                startIndex = e + 2;
                continue;
            }
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("substitution value, prefix, unsupported"));
            Object[] source = new Object[]{prefix};
            throw new Exception(form.format(source));
        }
        sb.append(pe.name.substring(startIndex));
        if (debug != null) {
            debug.println("  Permission name expanded from:\n\t" + pe.name + "\nto\n\t" + sb.toString());
        }
        pe.name = sb.toString();
    }

    private String getDN(String alias, KeyStore keystore) {
        Certificate cert = null;
        try {
            cert = keystore.getCertificate(alias);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.println("  Error retrieving certificate for '" + alias + "': " + e.toString());
            }
            return null;
        }
        if (cert == null || !(cert instanceof X509Certificate)) {
            if (debug != null) {
                debug.println("  -- No certificate for '" + alias + "' - ignoring entry");
            }
            return null;
        }
        X509Certificate x509Cert = (X509Certificate)cert;
        X500Principal p = new X500Principal(x509Cert.getSubjectX500Principal().toString());
        return p.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForTrustedIdentity(final Certificate cert, PolicyInfo myInfo) {
        if (cert == null) {
            return false;
        }
        if (this.ignoreIdentityScope) {
            return false;
        }
        Class<PolicyFile> clazz = PolicyFile.class;
        synchronized (PolicyFile.class) {
            IdentityScope is;
            if (scope == null && (is = IdentityScope.getSystemScope()) instanceof IdentityDatabase) {
                scope = is;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (scope == null) {
                this.ignoreIdentityScope = true;
                return false;
            }
            final Identity id = AccessController.doPrivileged(new PrivilegedAction<Identity>(){

                @Override
                public Identity run() {
                    return scope.getIdentity(cert.getPublicKey());
                }
            });
            if (PolicyFile.isTrusted(id)) {
                if (debug != null) {
                    debug.println("Adding policy entry for trusted Identity: ");
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            debug.println("  identity = " + String.valueOf(id));
                            return null;
                        }
                    });
                    debug.println("");
                }
                Certificate[] certs = new Certificate[]{cert};
                PolicyEntry pe = new PolicyEntry(new CodeSource(null, certs));
                pe.add(SecurityConstants.ALL_PERMISSION);
                myInfo.identityPolicyEntries.add(pe);
                myInfo.aliasMapping.put(cert, id.getName());
                return true;
            }
            return false;
        }
    }

    private static boolean isTrusted(Identity id) {
        SystemIdentity sysid;
        return id instanceof SystemIdentity ? (sysid = (SystemIdentity)id).isTrusted() : id instanceof SystemSigner && (sysid = (SystemSigner)id).isTrusted();
    }

    private static class PolicyInfo {
        private static final boolean verbose = false;
        final List<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        final List<PolicyEntry> identityPolicyEntries = Collections.synchronizedList(new ArrayList(2));
        final Map aliasMapping = Collections.synchronizedMap(new HashMap(11));
        private final JavaSecurityProtectionDomainAccess.ProtectionDomainCache[] pdMapping;
        private Random random;

        PolicyInfo(int numCaches) {
            this.pdMapping = new JavaSecurityProtectionDomainAccess.ProtectionDomainCache[numCaches];
            JavaSecurityProtectionDomainAccess jspda = SharedSecrets.getJavaSecurityProtectionDomainAccess();
            for (int i = 0; i < numCaches; ++i) {
                this.pdMapping[i] = jspda.getProtectionDomainCache();
            }
            if (numCaches > 1) {
                this.random = new Random();
            }
        }

        JavaSecurityProtectionDomainAccess.ProtectionDomainCache getPdMapping() {
            if (this.pdMapping.length == 1) {
                return this.pdMapping[0];
            }
            int i = Math.abs(this.random.nextInt() % this.pdMapping.length);
            return this.pdMapping[i];
        }
    }

    private static class PolicyEntry {
        private final CodeSource codesource;
        final List<Permission> permissions;
        private final List<PolicyParser.PrincipalEntry> principals;

        PolicyEntry(CodeSource cs, List<PolicyParser.PrincipalEntry> principals) {
            this.codesource = cs;
            this.permissions = new ArrayList<Permission>();
            this.principals = principals;
        }

        PolicyEntry(CodeSource cs) {
            this(cs, null);
        }

        List<PolicyParser.PrincipalEntry> getPrincipals() {
            return this.principals;
        }

        void add(Permission p) {
            this.permissions.add(p);
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(ResourcesMgr.getString("("));
            sb.append(this.getCodeSource());
            sb.append("\n");
            for (int j = 0; j < this.permissions.size(); ++j) {
                Permission p = this.permissions.get(j);
                sb.append(ResourcesMgr.getString(" "));
                sb.append(ResourcesMgr.getString(" "));
                sb.append(p);
                sb.append(ResourcesMgr.getString("\n"));
            }
            sb.append(ResourcesMgr.getString(")"));
            sb.append(ResourcesMgr.getString("\n"));
            return sb.toString();
        }
    }

    private static class SelfPermission
    extends Permission {
        private static final long serialVersionUID = -8315562579967246806L;
        private String type;
        private String name;
        private String actions;
        private Certificate[] certs;

        public SelfPermission(String type, String name, String actions, Certificate[] certs) {
            super(type);
            if (type == null) {
                throw new NullPointerException(ResourcesMgr.getString("type can't be null"));
            }
            this.type = type;
            this.name = name;
            this.actions = actions;
            if (certs != null) {
                int i;
                for (i = 0; i < certs.length; ++i) {
                    if (certs[i] instanceof X509Certificate) continue;
                    this.certs = (Certificate[])certs.clone();
                    break;
                }
                if (this.certs == null) {
                    int count = 0;
                    for (i = 0; i < certs.length; ++i) {
                        ++count;
                        while (i + 1 < certs.length && ((X509Certificate)certs[i]).getIssuerDN().equals(((X509Certificate)certs[i + 1]).getSubjectDN())) {
                            ++i;
                        }
                    }
                    if (count == certs.length) {
                        this.certs = (Certificate[])certs.clone();
                    }
                    if (this.certs == null) {
                        ArrayList<Certificate> signerCerts = new ArrayList<Certificate>();
                        for (i = 0; i < certs.length; ++i) {
                            signerCerts.add(certs[i]);
                            while (i + 1 < certs.length && ((X509Certificate)certs[i]).getIssuerDN().equals(((X509Certificate)certs[i + 1]).getSubjectDN())) {
                                ++i;
                            }
                        }
                        this.certs = new Certificate[signerCerts.size()];
                        signerCerts.toArray(this.certs);
                    }
                }
            }
        }

        @Override
        public boolean implies(Permission p) {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            int j;
            boolean match;
            int i;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SelfPermission)) {
                return false;
            }
            SelfPermission that = (SelfPermission)obj;
            if (!(this.type.equals(that.type) && this.name.equals(that.name) && this.actions.equals(that.actions))) {
                return false;
            }
            if (this.certs.length != that.certs.length) {
                return false;
            }
            for (i = 0; i < this.certs.length; ++i) {
                match = false;
                for (j = 0; j < that.certs.length; ++j) {
                    if (!this.certs[i].equals(that.certs[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            for (i = 0; i < that.certs.length; ++i) {
                match = false;
                for (j = 0; j < this.certs.length; ++j) {
                    if (!that.certs[i].equals(this.certs[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = this.type.hashCode();
            if (this.name != null) {
                hash ^= this.name.hashCode();
            }
            if (this.actions != null) {
                hash ^= this.actions.hashCode();
            }
            return hash;
        }

        @Override
        public String getActions() {
            return "";
        }

        public String getSelfType() {
            return this.type;
        }

        public String getSelfName() {
            return this.name;
        }

        public String getSelfActions() {
            return this.actions;
        }

        public Certificate[] getCerts() {
            return this.certs;
        }

        @Override
        public String toString() {
            return "(SelfPermission " + this.type + " " + this.name + " " + this.actions + ")";
        }
    }
}

