/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import com.unboundid.util.json.LDAPConnectionDetailsJSONSpecification;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class ConnectionPoolOptions {
    private static final String FIELD_CREATE_IF_NECESSARY = "create-if-necessary";
    private static final String FIELD_HEALTH_CHECK_GET_ENTRY_DN = "health-check-get-entry-dn";
    private static final String FIELD_HEALTH_CHECK_GET_ENTRY_TIMEOUT_MILLIS = "health-check-get-entry-maximum-response-time-millis";
    private static final String FIELD_HEALTH_CHECK_INTERVAL_MILLIS = "health-check-interval-millis";
    private static final String FIELD_INITIAL_CONNECT_THREADS = "initial-connect-threads";
    private static final String FIELD_INVOKE_BACKGROUND_HEALTH_CHECKS = "invoke-background-health-checks";
    private static final String FIELD_INVOKE_CHECKOUT_HEALTH_CHECKS = "invoke-checkout-health-checks";
    private static final String FIELD_INVOKE_CREATE_HEALTH_CHECKS = "invoke-create-health-checks";
    private static final String FIELD_INVOKE_EXCEPTION_HEALTH_CHECKS = "invoke-exception-health-checks";
    private static final String FIELD_INVOKE_RELEASE_HEALTH_CHECKS = "invoke-release-health-checks";
    private static final String FIELD_MAX_CONNECTION_AGE_MILLIS = "maximum-connection-age-millis";
    private static final String FIELD_MAX_DEFUNCT_REPLACEMENT_CONNECTION_AGE_MILLIS = "maximum-defunct-replacement-connection-age-millis";
    private static final String FIELD_MAX_WAIT_TIME_MILLIS = "maximum-wait-time-millis";
    private static final String FIELD_RETRY_FAILED_OPS = "retry-failed-operations-due-to-invalid-connections";
    private final boolean createIfNecessary;
    private final GetEntryLDAPConnectionPoolHealthCheck healthCheck;
    private final int initialConnectThreads;
    private final long healthCheckIntervalMillis;
    private final long maxConnectionAgeMillis;
    private final long maxWaitTimeMillis;
    private final Long maxDefunctReplacementConnectionAgeMillis;
    private final Set<OperationType> retryOperationTypes;

    ConnectionPoolOptions(JSONObject connectionDetailsObject) throws LDAPException {
        boolean create = true;
        boolean invokeBackground = true;
        boolean invokeCheckout = false;
        boolean invokeCreate = false;
        boolean invokeException = true;
        boolean invokeRelease = false;
        int initialThreads = 1;
        long getEntryTimeout = 10000L;
        long healthCheckInterval = 60000L;
        long maxConnectionAge = 0L;
        long maxWaitTime = 0L;
        Long maxDefunctReplacementAge = null;
        String getDN = null;
        EnumSet<OperationType> retryTypes = EnumSet.noneOf(OperationType.class);
        JSONObject o = LDAPConnectionDetailsJSONSpecification.getObject(connectionDetailsObject, "connection-pool-options");
        if (o != null) {
            LDAPConnectionDetailsJSONSpecification.validateAllowedFields(o, "connection-pool-options", FIELD_CREATE_IF_NECESSARY, FIELD_HEALTH_CHECK_GET_ENTRY_DN, FIELD_HEALTH_CHECK_GET_ENTRY_TIMEOUT_MILLIS, FIELD_HEALTH_CHECK_INTERVAL_MILLIS, FIELD_INITIAL_CONNECT_THREADS, FIELD_INVOKE_BACKGROUND_HEALTH_CHECKS, FIELD_INVOKE_CHECKOUT_HEALTH_CHECKS, FIELD_INVOKE_CREATE_HEALTH_CHECKS, FIELD_INVOKE_EXCEPTION_HEALTH_CHECKS, FIELD_INVOKE_RELEASE_HEALTH_CHECKS, FIELD_MAX_CONNECTION_AGE_MILLIS, FIELD_MAX_DEFUNCT_REPLACEMENT_CONNECTION_AGE_MILLIS, FIELD_MAX_WAIT_TIME_MILLIS, FIELD_RETRY_FAILED_OPS);
            create = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_CREATE_IF_NECESSARY, create);
            invokeBackground = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_INVOKE_BACKGROUND_HEALTH_CHECKS, invokeBackground);
            invokeCheckout = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_INVOKE_CHECKOUT_HEALTH_CHECKS, invokeCheckout);
            invokeCreate = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_INVOKE_CREATE_HEALTH_CHECKS, invokeCreate);
            invokeException = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_INVOKE_EXCEPTION_HEALTH_CHECKS, invokeException);
            invokeRelease = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_INVOKE_RELEASE_HEALTH_CHECKS, invokeRelease);
            initialThreads = LDAPConnectionDetailsJSONSpecification.getInt(o, FIELD_INITIAL_CONNECT_THREADS, initialThreads, 1, null);
            getEntryTimeout = LDAPConnectionDetailsJSONSpecification.getLong(o, FIELD_HEALTH_CHECK_GET_ENTRY_TIMEOUT_MILLIS, getEntryTimeout, 1L, null);
            healthCheckInterval = LDAPConnectionDetailsJSONSpecification.getLong(o, FIELD_HEALTH_CHECK_INTERVAL_MILLIS, healthCheckInterval, 1L, null);
            maxConnectionAge = LDAPConnectionDetailsJSONSpecification.getLong(o, FIELD_MAX_CONNECTION_AGE_MILLIS, maxConnectionAge, 0L, null);
            maxWaitTime = LDAPConnectionDetailsJSONSpecification.getLong(o, FIELD_MAX_WAIT_TIME_MILLIS, maxWaitTime, 0L, null);
            maxDefunctReplacementAge = LDAPConnectionDetailsJSONSpecification.getLong(o, FIELD_MAX_DEFUNCT_REPLACEMENT_CONNECTION_AGE_MILLIS, maxDefunctReplacementAge, 0L, null);
            getDN = LDAPConnectionDetailsJSONSpecification.getString(o, FIELD_HEALTH_CHECK_GET_ENTRY_DN, getDN);
            JSONValue retryTypesValue = o.getField(FIELD_RETRY_FAILED_OPS);
            if (retryTypesValue != null) {
                if (retryTypesValue instanceof JSONBoolean) {
                    if (((JSONBoolean)retryTypesValue).booleanValue()) {
                        retryTypes.addAll(EnumSet.allOf(OperationType.class));
                    }
                } else if (retryTypesValue instanceof JSONArray) {
                    for (JSONValue v : ((JSONArray)retryTypesValue).getValues()) {
                        if (v instanceof JSONString) {
                            String s = StaticUtils.toLowerCase(((JSONString)v).stringValue());
                            if (s.equals("add")) {
                                retryTypes.add(OperationType.ADD);
                                continue;
                            }
                            if (s.equals("bind")) {
                                retryTypes.add(OperationType.BIND);
                                continue;
                            }
                            if (s.equals("compare")) {
                                retryTypes.add(OperationType.COMPARE);
                                continue;
                            }
                            if (s.equals("delete")) {
                                retryTypes.add(OperationType.DELETE);
                                continue;
                            }
                            if (s.equals("extended")) {
                                retryTypes.add(OperationType.EXTENDED);
                                continue;
                            }
                            if (s.equals("modify")) {
                                retryTypes.add(OperationType.MODIFY);
                                continue;
                            }
                            if (s.equals("modify-dn")) {
                                retryTypes.add(OperationType.MODIFY_DN);
                                continue;
                            }
                            if (s.equals("search")) {
                                retryTypes.add(OperationType.SEARCH);
                                continue;
                            }
                            throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_POOL_OPTIONS_INVALID_RETRY_TYPES.get(FIELD_RETRY_FAILED_OPS));
                        }
                        throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_POOL_OPTIONS_INVALID_RETRY_TYPES.get(FIELD_RETRY_FAILED_OPS));
                    }
                } else {
                    throw new LDAPException(ResultCode.PARAM_ERROR, JSONMessages.ERR_POOL_OPTIONS_INVALID_RETRY_TYPES.get(FIELD_RETRY_FAILED_OPS));
                }
            }
        }
        this.createIfNecessary = create;
        this.initialConnectThreads = initialThreads;
        this.healthCheckIntervalMillis = healthCheckInterval;
        this.maxConnectionAgeMillis = maxConnectionAge;
        this.maxDefunctReplacementConnectionAgeMillis = maxDefunctReplacementAge;
        this.maxWaitTimeMillis = maxWaitTime;
        this.retryOperationTypes = Collections.unmodifiableSet(retryTypes);
        this.healthCheck = getDN == null ? null : new GetEntryLDAPConnectionPoolHealthCheck(getDN, getEntryTimeout, invokeCreate, invokeCheckout, invokeRelease, invokeBackground, invokeException);
    }

    int getInitialConnectThreads() {
        return this.initialConnectThreads;
    }

    GetEntryLDAPConnectionPoolHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    void applyConnectionPoolSettings(LDAPConnectionPool pool) {
        pool.setCreateIfNecessary(this.createIfNecessary);
        pool.setHealthCheckIntervalMillis(this.healthCheckIntervalMillis);
        pool.setMaxConnectionAgeMillis(this.maxConnectionAgeMillis);
        pool.setMaxDefunctReplacementConnectionAgeMillis(this.maxDefunctReplacementConnectionAgeMillis);
        pool.setMaxWaitTimeMillis(this.maxWaitTimeMillis);
        pool.setRetryFailedOperationsDueToInvalidConnections(this.retryOperationTypes);
    }
}

