/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipError;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.s2e.environment.JobFuture;

public abstract class AbstractJob
extends Job {
    private StackTraceElement[] m_callerTrace;
    private volatile IProgressMonitor m_monitor;

    protected AbstractJob(String name) {
        super(name);
    }

    public boolean shouldSchedule() {
        this.m_callerTrace = Thread.currentThread().getStackTrace();
        return super.shouldSchedule();
    }

    public static void waitForJobFamily(Object family) {
        boolean wasInterrupted;
        do {
            wasInterrupted = false;
            try {
                Job.getJobManager().join(family, null);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException e) {
                SdkLog.debug((Object[])new Object[]{e});
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public boolean isCanceled() {
        return this.monitor().map(IProgressMonitor::isCanceled).orElse(Boolean.FALSE);
    }

    public Optional<IProgressMonitor> monitor() {
        return Optional.ofNullable(this.m_monitor);
    }

    public IFuture<Void> scheduleWithFuture() {
        return this.scheduleWithFuture(0L, TimeUnit.MILLISECONDS);
    }

    public IFuture<Void> scheduleWithFuture(long delay, TimeUnit unit) {
        return this.scheduleWithFuture(delay, unit, null);
    }

    public <T> IFuture<T> scheduleWithFuture(long delay, TimeUnit unit, Supplier<T> resultExtractor) {
        JobFuture<T> result = new JobFuture<T>(this, resultExtractor);
        this.schedule(unit.toMillis(delay));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        long start = System.currentTimeMillis();
        try {
            this.m_monitor = monitor;
            iStatus = this.runInternal(monitor);
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - start;
            String logMsg = "Job '{}' finished after {}ms.";
            if (SdkLog.isDebugEnabled()) {
                SdkLog.debug((CharSequence)(logMsg + " It has been scheduled by:{}"), (Object[])new Object[]{this.getName(), duration, this.getCallerStackTrace()});
            } else {
                SdkLog.info((CharSequence)logMsg, (Object[])new Object[]{this.getName(), duration});
            }
            throw throwable;
        }
        long duration = System.currentTimeMillis() - start;
        String logMsg = "Job '{}' finished after {}ms.";
        if (SdkLog.isDebugEnabled()) {
            SdkLog.debug((CharSequence)(logMsg + " It has been scheduled by:{}"), (Object[])new Object[]{this.getName(), duration, this.getCallerStackTrace()});
        } else {
            SdkLog.info((CharSequence)logMsg, (Object[])new Object[]{this.getName(), duration});
        }
        return iStatus;
    }

    protected String getCallerStackTrace() {
        int numElementsToRemove = 4;
        if (this.m_callerTrace == null || this.m_callerTrace.length <= numElementsToRemove) {
            this.m_callerTrace = Thread.currentThread().getStackTrace();
            numElementsToRemove = 3;
        }
        StackTraceElement[] cleaned = new StackTraceElement[this.m_callerTrace.length - numElementsToRemove];
        System.arraycopy(this.m_callerTrace, numElementsToRemove, cleaned, 0, cleaned.length);
        return Arrays.stream(cleaned).map(traceElement -> "\n\tat " + String.valueOf(traceElement)).collect(Collectors.joining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus runInternal(IProgressMonitor monitor) {
        try {
            this.execute(monitor);
            if (monitor.isCanceled()) {
                SdkLog.debug((CharSequence)"Job '{}' has been canceled by monitor.", (Object[])new Object[]{this.getName()});
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CancellationException ce) {
            SdkLog.debug((CharSequence)"Job '{}' has been canceled.", (Object[])new Object[]{this.getName(), ce});
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (OperationCanceledException ce) {
            SdkLog.debug((CharSequence)"Job '{}' has been canceled.", (Object[])new Object[]{this.getName(), ce});
            throw ce;
        }
        catch (LinkageError | RuntimeException | ZipError | CoreException e) {
            SdkLog.error((Object[])new Object[]{e});
            Status status = new Status(4, "org.eclipse.scout.sdk.s2e", e.getMessage(), e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void execute(IProgressMonitor var1) throws CoreException;
}

