/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment;

import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.WorkingCopyManager;

public class OperationJob
extends AbstractJob {
    private final BiConsumer<? super EclipseEnvironment, ? super EclipseProgress> m_operation;

    protected OperationJob(BiConsumer<? super EclipseEnvironment, ? super EclipseProgress> operation, String jobName) {
        super((String)Ensure.notNull((Object)jobName));
        this.m_operation = (BiConsumer)Ensure.notNull(operation);
    }

    public static String getJobName(Object op) {
        return CoreUtils.toStringIfOverwritten((Object)op).orElse("");
    }

    @Override
    protected void execute(IProgressMonitor monitor) {
        int workForCommit = 1;
        int workForOperation = 10000;
        EclipseProgress progress = EclipseEnvironment.toScoutProgress(monitor).init(workForOperation + workForCommit, this.getName(), new Object[0]);
        WorkingCopyManager.runWithWorkingCopyManager(() -> this.executeWithWorkingCopyManager(progress.newChild(workForOperation)), () -> progress.newChild(workForCommit).monitor());
    }

    protected void executeWithWorkingCopyManager(EclipseProgress eclipseProgress) {
        try (EclipseEnvironment env = new EclipseEnvironment();){
            this.operation().accept(env, eclipseProgress);
        }
    }

    public BiConsumer<? super EclipseEnvironment, ? super EclipseProgress> operation() {
        return this.m_operation;
    }
}

