/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.wellform;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.apidef.IClassNameSupplier;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.s.apidef.ScoutApi;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.operation.wellform.WellformScoutTypeOperation;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class WellformAllOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    @Override
    public void accept(EclipseEnvironment env, EclipseProgress p) {
        int numTicks = 100;
        int searchStepTicks = 1;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)p.monitor(), (String)"Wellform Scout classes...", (int)numTicks);
        progress.subTask("Searching for classes...");
        HashSet<IType> types = new HashSet<IType>();
        Set<String> roots = WellformAllOperation.getRootClasses();
        for (String root : roots) {
            Set<IType> rootTypes = JdtUtils.resolveJdtTypes(root);
            for (IType t : rootTypes) {
                try {
                    ITypeHierarchy typeHierarchy = t.newTypeHierarchy(null);
                    for (IType candidate : typeHierarchy.getAllClasses()) {
                        if (JdtUtils.exists((IJavaElement)candidate) && !candidate.isInterface() && !candidate.isBinary() && !candidate.isAnonymous() && candidate.getDeclaringType() == null) {
                            types.add(candidate);
                        }
                        if (!progress.isCanceled()) continue;
                        return;
                    }
                }
                catch (JavaModelException e) {
                    SdkLog.warning((CharSequence)"Unable to collect classes to wellform for base type '{}'. These classes will be skipped.", (Object[])new Object[]{t.getFullyQualifiedName(), e});
                }
            }
            progress.worked(searchStepTicks);
        }
        progress.subTask("Wellform classes...");
        new WellformScoutTypeOperation(types, true).accept(env, p.newChild(numTicks - searchStepTicks * roots.size()));
    }

    protected static Set<String> getRootClasses() {
        return ScoutApi.allKnown().flatMap(WellformAllOperation::getRootClasses).map(IClassNameSupplier::fqn).collect(Collectors.toSet());
    }

    protected static Stream<IClassNameSupplier> getRootClasses(IScoutInterfaceApi api) {
        return Stream.of(api.ICodeType(), api.IDesktop(), api.IDesktopExtension(), api.IForm(), api.IWizard(), api.IPage(), api.IOutline());
    }

    public String toString() {
        return "Wellform all Scout classes";
    }
}

