/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template.ast;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.scout.sdk.core.s.annotation.FormDataAnnotation;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.classid.ClassIds;
import org.eclipse.scout.sdk.core.s.uniqueid.UniqueIds;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstBigDecimalFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstButtonBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstCalendarFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstCodeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstColumnBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstDateFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstExtensionBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstFormHandlerBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstImageFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstInnerTypeGetterBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstKeyStrokeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstLabelFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstListBoxBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstLongFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstMenuBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstMethodBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstRadioButtonBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstSequenceBoxBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstStringFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstTableFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstTreeFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstValueFieldBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.WrappedTrackedNodePosition;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstNodeFactory {
    public static final String SUPER_TYPE_GROUP = "SUPER_TYPE";
    public static final String TYPE_NAME_GROUP = "TYPE_NAME";
    public static final String NLS_KEY_GROUP = "NLS_KEY";
    public static final String ID_DATA_TYPE_GROUP = "ID_DATA_TYPE";
    public static final String ID_VALUE_GROUP = "ID_VALUE";
    public static final String CODE_DATA_TYPE_GROUP = "CODE_DATA_TYPE";
    public static final String MIN_GROUP = "MIN";
    public static final String MAX_GROUP = "MAX";
    public static final String CALENDAR_ITEM_PROVIDER_NAME_GROUP = "CALENDAR_ITEM_PROVIDER_NAME";
    public static final String GRID_H_GROUP = "GRID_H";
    public static final String LABEL_VISIBLE_GROUP = "LABEL_VISIBLE";
    public static final String WIDTH_VALUE_GROUP = "WIDTH_VALUE";
    public static final String MAX_LEN_GROUP = "MAX_LEN";
    public static final String VALUE_TYPE_GROUP = "VALUE_TYPE";
    public static final String KEY_STROKE_GROUP = "KEY_STROKE";
    public static final String RADIO_VALUE_TYPE_GROUP = "RADIO_VALUE_TYPE";
    public static final String RADIO_VALUE_GROUP = "RADIO_VALUE";
    public static final String AUTO_CHECK_GROUP = "AUTO_CHECK";
    public static final String MENU_TYPE_GROUP = "MENU_TYPE";
    public static final String EXTENDS_TYPE_GROUP = "EXTENDS_TYPE_GROUP";
    public static final String AUTO_FIT_GROUP = "AUTO_FIT";
    private final AST m_ast;
    private final TypeDeclaration m_declaringType;
    private final ITypeBinding m_declaringTypeBinding;
    private final ASTRewrite m_rewrite;
    private final CompilationUnit m_root;
    private final ImportRewrite m_importRewrite;
    private final ListRewrite m_importsRewrite;
    private final ImportRewrite.ImportRewriteContext m_context;
    private final EclipseEnvironment m_javaEnvProvider;
    private final CodeGenerationSettings m_settings;
    private final ICompilationUnit m_icu;
    private final IJavaProject m_javaProject;
    private final ILinkedPositionHolder m_linkedPosHolder;
    private final IScoutApi m_scoutApi;

    public AstNodeFactory(TypeDeclaration type, ICompilationUnit icu, EclipseEnvironment envProvider, IScoutApi api) {
        this(type, icu, envProvider, api, ((TypeDeclaration)Ensure.notNull((Object)type)).resolveBinding());
    }

    public AstNodeFactory(TypeDeclaration type, ICompilationUnit icu, EclipseEnvironment envProvider, IScoutApi api, ITypeBinding declaringTypeBinding) {
        this(type, icu, envProvider, api, declaringTypeBinding, null);
    }

    public AstNodeFactory(TypeDeclaration type, ICompilationUnit icu, EclipseEnvironment envProvider, IScoutApi api, ITypeBinding declaringTypeBinding, ILinkedPositionHolder linkHolder) {
        this.m_declaringType = (TypeDeclaration)Ensure.notNull((Object)type);
        this.m_declaringTypeBinding = (ITypeBinding)Ensure.notNull((Object)declaringTypeBinding);
        this.m_javaEnvProvider = (EclipseEnvironment)Ensure.notNull((Object)envProvider);
        this.m_icu = (ICompilationUnit)Ensure.notNull((Object)icu);
        this.m_scoutApi = (IScoutApi)Ensure.notNull((Object)api);
        this.m_ast = this.m_declaringType.getAST();
        this.m_rewrite = ASTRewrite.create((AST)this.m_ast);
        this.m_root = (CompilationUnit)type.getRoot();
        this.m_importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)this.m_root, (boolean)true);
        if (this.m_root.getAST().hasResolvedBindings()) {
            this.m_importRewrite.setUseContextToFilterImplicitImports(true);
        }
        this.m_importsRewrite = this.m_rewrite.getListRewrite((ASTNode)this.m_root, CompilationUnit.IMPORTS_PROPERTY);
        this.m_context = new ContextSensitiveImportRewriteContext((ASTNode)this.m_root, this.m_importRewrite);
        this.m_javaProject = this.m_icu.getJavaProject();
        this.m_settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)this.m_javaProject);
        this.m_linkedPosHolder = linkHolder;
    }

    public AstTypeBuilder<?> newType(String name) {
        return new AstTypeBuilder(this).withName((String)Ensure.notNull((Object)name));
    }

    public AstMethodBuilder<?> newMethod(String name) {
        return new AstMethodBuilder(this).withName((String)Ensure.notNull((Object)name));
    }

    public AstInnerTypeGetterBuilder newInnerTypeGetter() {
        return new AstInnerTypeGetterBuilder(this);
    }

    public AstCodeBuilder newCode(String name) {
        return (AstCodeBuilder)((AstCodeBuilder)((AstCodeBuilder)((AstCodeBuilder)((AstCodeBuilder)((AstCodeBuilder)new AstCodeBuilder(this).withClassId(true)).withName(name)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD)).withNlsMethod(this.getScoutApi().AbstractCode().getConfiguredTextMethodName())).withOrder(true)).withOrderDefinitionType(this.getScoutApi().ICode().fqn());
    }

    public AstButtonBuilder newButton(String name) {
        return (AstButtonBuilder)((AstButtonBuilder)((AstButtonBuilder)((AstButtonBuilder)((AstButtonBuilder)new AstButtonBuilder(this).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withClassId(true)).withName(name);
    }

    public AstBigDecimalFieldBuilder newBigDecimalField(String name) {
        return (AstBigDecimalFieldBuilder)((AstBigDecimalFieldBuilder)((AstBigDecimalFieldBuilder)((AstBigDecimalFieldBuilder)((AstBigDecimalFieldBuilder)new AstBigDecimalFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstImageFieldBuilder newImageField(String name) {
        return (AstImageFieldBuilder)((AstImageFieldBuilder)((AstImageFieldBuilder)((AstImageFieldBuilder)((AstImageFieldBuilder)new AstImageFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstCalendarFieldBuilder newCalendarField(String name) {
        return (AstCalendarFieldBuilder)((AstCalendarFieldBuilder)((AstCalendarFieldBuilder)((AstCalendarFieldBuilder)((AstCalendarFieldBuilder)new AstCalendarFieldBuilder(this).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withClassId(true)).withName(name);
    }

    public AstColumnBuilder newColumn(String name) {
        return (AstColumnBuilder)((AstColumnBuilder)((AstColumnBuilder)((AstColumnBuilder)((AstColumnBuilder)((AstColumnBuilder)((AstColumnBuilder)new AstColumnBuilder(this).withClassId(true)).withName(name)).withNlsMethod(this.getScoutApi().AbstractColumn().getConfiguredHeaderTextMethodName())).withCalculatedOrder(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IColumn().fqn());
    }

    public AstDateFieldBuilder newDateField(String name) {
        return (AstDateFieldBuilder)((AstDateFieldBuilder)((AstDateFieldBuilder)((AstDateFieldBuilder)((AstDateFieldBuilder)new AstDateFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstLabelFieldBuilder newLabelField(String name) {
        return (AstLabelFieldBuilder)((AstLabelFieldBuilder)((AstLabelFieldBuilder)((AstLabelFieldBuilder)((AstLabelFieldBuilder)new AstLabelFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstLongFieldBuilder newLongField(String name) {
        return (AstLongFieldBuilder)((AstLongFieldBuilder)((AstLongFieldBuilder)((AstLongFieldBuilder)((AstLongFieldBuilder)new AstLongFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstStringFieldBuilder newStringField(String name) {
        return (AstStringFieldBuilder)((AstStringFieldBuilder)((AstStringFieldBuilder)((AstStringFieldBuilder)((AstStringFieldBuilder)new AstStringFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstValueFieldBuilder<?> newValueField(String name) {
        return (AstValueFieldBuilder)((AstValueFieldBuilder)((AstValueFieldBuilder)((AstValueFieldBuilder)((AstValueFieldBuilder)new AstValueFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstFormHandlerBuilder newFormHandler(String name) {
        return (AstFormHandlerBuilder)((AstFormHandlerBuilder)((AstFormHandlerBuilder)((AstFormHandlerBuilder)((AstFormHandlerBuilder)new AstFormHandlerBuilder(this).withName(name)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(false)).withOrderDefinitionType(null)).withCalculatedOrder(false);
    }

    public AstKeyStrokeBuilder newKeyStroke(String name) {
        return (AstKeyStrokeBuilder)((AstKeyStrokeBuilder)((AstKeyStrokeBuilder)((AstKeyStrokeBuilder)((AstKeyStrokeBuilder)((AstKeyStrokeBuilder)new AstKeyStrokeBuilder(this).withClassId(true)).withName(name)).withCalculatedOrder(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IKeyStroke().fqn());
    }

    public AstListBoxBuilder newListBox(String name) {
        return (AstListBoxBuilder)((AstListBoxBuilder)((AstListBoxBuilder)((AstListBoxBuilder)((AstListBoxBuilder)new AstListBoxBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstRadioButtonBuilder newRadioButton(String name) {
        return (AstRadioButtonBuilder)((AstRadioButtonBuilder)((AstRadioButtonBuilder)((AstRadioButtonBuilder)((AstRadioButtonBuilder)new AstRadioButtonBuilder(this).withClassId(true)).withName(name)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withOrder(true);
    }

    public AstSequenceBoxBuilder newSequenceBox(String name) {
        return (AstSequenceBoxBuilder)((AstSequenceBoxBuilder)((AstSequenceBoxBuilder)((AstSequenceBoxBuilder)((AstSequenceBoxBuilder)new AstSequenceBoxBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstTreeFieldBuilder newTreeField(String name) {
        return (AstTreeFieldBuilder)((AstTreeFieldBuilder)((AstTreeFieldBuilder)((AstTreeFieldBuilder)((AstTreeFieldBuilder)new AstTreeFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstTableFieldBuilder newTableField(String name) {
        return (AstTableFieldBuilder)((AstTableFieldBuilder)((AstTableFieldBuilder)((AstTableFieldBuilder)((AstTableFieldBuilder)new AstTableFieldBuilder(this).withClassId(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withOrderDefinitionType(this.getScoutApi().IFormField().fqn())).withName(name);
    }

    public AstMenuBuilder newMenu(String name) {
        return (AstMenuBuilder)((AstMenuBuilder)((AstMenuBuilder)((AstMenuBuilder)((AstMenuBuilder)((AstMenuBuilder)((AstMenuBuilder)new AstMenuBuilder(this).withClassId(true)).withName(name)).withCalculatedOrder(true)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(true)).withNlsMethod(this.getScoutApi().AbstractAction().getConfiguredTextMethodName())).withOrderDefinitionType(this.getScoutApi().IMenu().fqn());
    }

    public AstTypeBuilder<?> newExtension(String name) {
        return ((AstExtensionBuilder)((AstExtensionBuilder)((AstExtensionBuilder)((AstExtensionBuilder)((AstExtensionBuilder)new AstExtensionBuilder(this).withName(name)).withNlsMethod(null)).withCalculatedOrder(false)).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withOrder(false)).withOrderDefinitionType(null);
    }

    public Expression newDefaultValueExpression(String fqn, boolean useUniqueId) {
        String uniqueId;
        String unboxed = JavaTypes.unboxToPrimitive((CharSequence)fqn);
        boolean isPrimitive = JavaTypes.isPrimitive((CharSequence)unboxed);
        if (useUniqueId && Strings.hasText((CharSequence)(uniqueId = UniqueIds.next((String)fqn)))) {
            if (isPrimitive) {
                return this.getAst().newNumberLiteral(uniqueId);
            }
            StringLiteral literal = this.getAst().newStringLiteral();
            literal.setEscapedValue(uniqueId);
            return literal;
        }
        if (!isPrimitive) {
            return this.getAst().newNullLiteral();
        }
        if ("void".equals(unboxed)) {
            return null;
        }
        if ("boolean".equals(unboxed)) {
            return this.getAst().newBooleanLiteral(false);
        }
        String defaultValue = JavaTypes.defaultValueOf((CharSequence)unboxed);
        return this.getAst().newNumberLiteral(defaultValue);
    }

    public Type newTypeReference(String fqn) {
        String type = this.getImportRewrite().addImport(fqn, this.getContext());
        return this.getAst().newSimpleType((Name)this.getAst().newSimpleName(type));
    }

    public NormalAnnotation newFormDataIgnoreAnnotation() {
        String formDataRef = this.getImportRewrite().addImport(this.getScoutApi().FormData().fqn(), this.getContext());
        NormalAnnotation formData = this.getAst().newNormalAnnotation();
        formData.setTypeName(this.getAst().newName(formDataRef));
        MemberValuePair sdkCommand = this.getAst().newMemberValuePair();
        sdkCommand.setName(this.getAst().newSimpleName(this.getScoutApi().FormData().sdkCommandElementName()));
        sdkCommand.setValue((Expression)this.getAst().newQualifiedName((Name)this.getAst().newQualifiedName((Name)this.getAst().newSimpleName(formDataRef), this.getAst().newSimpleName(FormDataAnnotation.SdkCommand.class.getSimpleName())), this.getAst().newSimpleName(FormDataAnnotation.SdkCommand.IGNORE.toString())));
        formData.values().add(sdkCommand);
        return formData;
    }

    public SingleMemberAnnotation newClassIdAnnotation(String fqn) {
        String classIdFqn = this.getScoutApi().ClassId().fqn();
        String classIdRef = this.getImportRewrite().addImport(classIdFqn, this.getContext());
        SingleMemberAnnotation classIdAnnotation = this.getAst().newSingleMemberAnnotation();
        classIdAnnotation.setTypeName(this.getAst().newName(classIdRef));
        String newId = ClassIds.next((String)fqn);
        if (Strings.isBlank((CharSequence)newId)) {
            newId = "UNDEFINED";
        }
        StringLiteral id = this.getAst().newStringLiteral();
        id.setLiteralValue(newId);
        classIdAnnotation.setValue((Expression)id);
        return classIdAnnotation;
    }

    public AstMethodBuilder<?> newGetConfiguredGridH(int gridHValue) {
        return this.newGetConfigured(gridHValue, this.getScoutApi().AbstractFormField().getConfiguredGridHMethodName(), GRID_H_GROUP);
    }

    public AstMethodBuilder<?> newGetConfiguredWidth(int width) {
        return this.newGetConfigured(width, this.getScoutApi().AbstractColumn().getConfiguredWidthMethodName(), WIDTH_VALUE_GROUP);
    }

    protected AstMethodBuilder<?> newGetConfigured(int value, String name, String group) {
        NumberLiteral literal = this.getAst().newNumberLiteral(Integer.toString(value));
        ReturnStatement returnStatement = this.getAst().newReturnStatement();
        returnStatement.setExpression((Expression)literal);
        Block body = this.getAst().newBlock();
        body.statements().add(returnStatement);
        ILinkedPositionHolder links = this.getLinkedPositionHolder();
        if (links != null) {
            links.addLinkedPosition(this.getRewrite().track((ASTNode)literal), true, group);
        }
        return ((AstMethodBuilder)((AstMethodBuilder)((AstMethodBuilder)this.newMethod(name).withModifiers(Modifier.ModifierKeyword.PROTECTED_KEYWORD)).withOverride(true)).withReturnType((Type)this.getAst().newPrimitiveType(PrimitiveType.INT))).withBody(body);
    }

    public MethodInvocation newCombineKeyStrokes(String ... elementsToCombine) {
        AST ast = this.getAst();
        String iKeyStroke = this.getImportRewrite().addImport(this.getScoutApi().IKeyStroke().fqn());
        MethodInvocation combineKeyStrokes = ast.newMethodInvocation();
        combineKeyStrokes.setName(ast.newSimpleName(this.getScoutApi().AbstractAction().combineKeyStrokesMethodName()));
        Type keyStrokeRef = this.newTypeReference(this.getScoutApi().AbstractAction().fqn());
        combineKeyStrokes.setExpression((Expression)ast.newSimpleName(keyStrokeRef.toString()));
        List arguments = combineKeyStrokes.arguments();
        for (String element : elementsToCombine) {
            if (element.length() < 2) {
                StringLiteral literal = ast.newStringLiteral();
                literal.setLiteralValue(element);
                arguments.add(literal);
                continue;
            }
            arguments.add(ast.newQualifiedName(ast.newName(iKeyStroke), ast.newSimpleName(element)));
        }
        return combineKeyStrokes;
    }

    public AstMethodBuilder<?> newNlsMethod(String methodName) {
        AST ast = this.getAst();
        MethodInvocation get = ast.newMethodInvocation();
        IScoutVariousApi.TEXTS textsApi = this.getScoutApi().TEXTS();
        get.setName(ast.newSimpleName(textsApi.getMethodName()));
        String textsRef = this.getImportRewrite().addImport(textsApi.fqn(), this.getContext());
        get.setExpression((Expression)ast.newName(textsRef));
        StringLiteral nlsKeyString = ast.newStringLiteral();
        nlsKeyString.setLiteralValue("MyNlsKey");
        get.arguments().add(nlsKeyString);
        ReturnStatement returnStatement = ast.newReturnStatement();
        returnStatement.setExpression((Expression)get);
        Block body = ast.newBlock();
        body.statements().add(returnStatement);
        ILinkedPositionHolder links = this.getLinkedPositionHolder();
        if (links != null) {
            WrappedTrackedNodePosition nlsKeyLiteralPos = new WrappedTrackedNodePosition(this.getRewrite().track((ASTNode)nlsKeyString), 1, -2);
            links.addLinkedPosition(nlsKeyLiteralPos, true, NLS_KEY_GROUP);
        }
        return ((AstMethodBuilder)((AstMethodBuilder)((AstMethodBuilder)this.newMethod(methodName).withModifiers(Modifier.ModifierKeyword.PROTECTED_KEYWORD)).withOverride(true)).withReturnType(this.newTypeReference(String.class.getName()))).withBody(body);
    }

    public AstMethodBuilder<?> newExecMethod(String name) {
        return ((AstMethodBuilder)((AstMethodBuilder)this.newMethod(name).withModifiers(Modifier.ModifierKeyword.PROTECTED_KEYWORD)).withOverride(true)).withReturnType((Type)this.getAst().newPrimitiveType(PrimitiveType.VOID));
    }

    public AstMethodBuilder<?> newGetConfiguredLabelVisible() {
        AST ast = this.getAst();
        BooleanLiteral literal = ast.newBooleanLiteral(false);
        ReturnStatement returnStatement = ast.newReturnStatement();
        returnStatement.setExpression((Expression)literal);
        Block body = ast.newBlock();
        body.statements().add(returnStatement);
        ILinkedPositionHolder links = this.getLinkedPositionHolder();
        if (links != null) {
            links.addLinkedPosition(this.getRewrite().track((ASTNode)literal), true, LABEL_VISIBLE_GROUP);
            links.addLinkedPositionProposalsBoolean(LABEL_VISIBLE_GROUP);
        }
        return ((AstMethodBuilder)((AstMethodBuilder)((AstMethodBuilder)this.newMethod(this.getScoutApi().AbstractFormField().getConfiguredLabelVisibleMethodName()).withModifiers(Modifier.ModifierKeyword.PROTECTED_KEYWORD)).withOverride(true)).withReturnType((Type)ast.newPrimitiveType(PrimitiveType.BOOLEAN))).withBody(body);
    }

    public FieldDeclaration newSerialVersionUid() {
        AST ast = this.getAst();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName("serialVersionUID"));
        fragment.setInitializer((Expression)ast.newNumberLiteral("1L"));
        FieldDeclaration declaration = ast.newFieldDeclaration(fragment);
        declaration.setType((Type)ast.newPrimitiveType(PrimitiveType.LONG));
        declaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        declaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        declaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        return declaration;
    }

    public MarkerAnnotation newOverrideAnnotation() {
        String overrideRef = this.getImportRewrite().addImport(Override.class.getName(), this.getContext());
        MarkerAnnotation marker = this.getAst().newMarkerAnnotation();
        marker.setTypeName(this.getAst().newName(overrideRef));
        return marker;
    }

    public ITypeBinding resolveTypeBinding(String fqn) {
        ITypeBinding wellKnownType = this.getAst().resolveWellKnownType(fqn);
        if (wellKnownType != null) {
            return wellKnownType;
        }
        try {
            Object resolver = AstUtils.getBindingResolver((AST)this.getAst());
            CompilationUnitScope unitScope = AstUtils.getCompilationUnitScope((Object)resolver);
            ReferenceBinding reference = unitScope.environment.getResolvedType(CharOperation.splitOn((char)'.', (char[])fqn.toCharArray()), (Scope)unitScope);
            Method getTypeBinding = resolver.getClass().getDeclaredMethod("getTypeBinding", TypeBinding.class);
            getTypeBinding.setAccessible(true);
            return (ITypeBinding)getTypeBinding.invoke(resolver, reference);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException t) {
            throw new SdkException((Throwable)t);
        }
    }

    public ImportRewrite.ImportRewriteContext getContext() {
        return this.m_context;
    }

    public ILinkedPositionHolder getLinkedPositionHolder() {
        return this.m_linkedPosHolder;
    }

    public AST getAst() {
        return this.m_ast;
    }

    public TypeDeclaration getType() {
        return this.m_declaringType;
    }

    public CompilationUnit getRoot() {
        return this.m_root;
    }

    public ICompilationUnit getIcu() {
        return this.m_icu;
    }

    public ImportRewrite getImportRewrite() {
        return this.m_importRewrite;
    }

    public ASTRewrite getRewrite() {
        return this.m_rewrite;
    }

    public ListRewrite getImportsRewriteList() {
        return this.m_importsRewrite;
    }

    public ITypeBinding getDeclaringTypeBinding() {
        return this.m_declaringTypeBinding;
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public EclipseEnvironment getScoutElementProvider() {
        return this.m_javaEnvProvider;
    }

    public IScoutApi getScoutApi() {
        return this.m_scoutApi;
    }

    protected boolean isCreateOverrideAnnotationSetting() {
        return this.m_settings != null && this.m_settings.overrideAnnotation;
    }

    protected boolean isCreateCommentsSetting() {
        return this.m_settings != null && this.m_settings.createComments;
    }
}

