/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.test;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.rt.client.services.common.test.AbstractClientTest;
import org.eclipse.scout.rt.client.services.common.test.ClientTestUtility;
import org.eclipse.scout.rt.client.test.IPageTest;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.bigintegerfield.IBigIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.IDoubleField;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.IIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.ITreeBox;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class DrilldownOutlineUnitTest
extends AbstractClientTest {
    private final Set<CompositeObject> visitedPages = new HashSet<CompositeObject>();
    private IPageTest[] m_pageTester;

    protected void clearVisitCache() {
        this.visitedPages.clear();
    }

    public void setUp() {
        this.m_pageTester = (IPageTest[])SERVICES.getServices(IPageTest.class);
    }

    public void run() throws Exception {
        this.clearVisitCache();
        IOutline[] iOutlineArray = ClientTestUtility.getDesktop().getAvailableOutlines();
        int n = iOutlineArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutline outline = iOutlineArray[n2];
            if (outline.isVisible() && outline.isEnabled()) {
                ClientTestUtility.getDesktop().setOutline(outline);
                this.testPage(outline.getRootPage());
            }
            ++n2;
        }
    }

    public void tearDown() throws Throwable {
        this.clearVisitCache();
    }

    protected void testPage(IPage page) throws ProcessingException {
        if (page == null) {
            return;
        }
        if (page != page.getTree().getRootNode()) {
            CompositeObject key;
            Class<?> pageClass = page.getClass();
            Class<?> parentClass = null;
            if (page.getParentPage() != null) {
                parentClass = page.getParentPage().getClass();
            }
            if (this.visitedPages.contains(key = new CompositeObject(new Object[]{parentClass, pageClass}))) {
                return;
            }
            this.visitedPages.add(key);
        }
        this.setSubTitle(String.valueOf(page.getCell().getText()) + " [" + page.getClass().getSimpleName() + "]");
        try {
            if (page.isVisible() && page.isEnabled()) {
                page.getOutline().selectNode(page);
                IPageTest[] iPageTestArray = this.m_pageTester;
                int n = this.m_pageTester.length;
                int n2 = 0;
                while (n2 < n) {
                    IPageTest tester = iPageTestArray[n2];
                    if (tester.canHandle(page)) {
                        page = tester.testPage(page);
                        break;
                    }
                    ++n2;
                }
                if (page != null && page.isVisible() && page.isEnabled()) {
                    if (page instanceof IPageWithTable) {
                        this.testPageWithTable((IPageWithTable)page);
                        this.addOkStatus(null);
                    } else if (page instanceof IPageWithNodes) {
                        this.testPageWithNodes((IPageWithNodes)page);
                        this.addOkStatus(null);
                    } else {
                        this.addWarningStatus("unsupported page type: " + page.getClass().getCanonicalName());
                    }
                }
            }
        }
        catch (Throwable t) {
            this.addErrorStatus(t.getMessage(), t);
        }
    }

    protected void testPageWithTable(IPageWithTable<?> page) throws ProcessingException {
        ISearchForm searchForm = page.getSearchFormInternal();
        P_LimitingResultSetSearchFormListener searchFormListener = null;
        if (searchForm != null) {
            searchFormListener = new P_LimitingResultSetSearchFormListener(searchForm);
            searchForm.addFormListener(searchFormListener);
            this.testSearchForm(page, searchForm);
            if (page.isSearchRequired()) {
                searchForm.doReset();
                this.fillMandatoryFields(searchForm);
                searchForm.doSaveWithoutMarkerChange();
            }
            searchForm.removeFormListener(searchFormListener);
        }
        if (page.getChildNodeCount() > 0) {
            IPage child = page.getChildPage(0);
            this.testPage(child);
        }
    }

    protected void testPageWithNodes(IPageWithNodes page) throws ProcessingException {
        IPage[] iPageArray = page.getChildPages();
        int n = iPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPage childPage = iPageArray[n2];
            this.testPage(childPage);
            ++n2;
        }
    }

    protected void testSearchForm(IPageWithTable<?> page, ISearchForm searchForm) throws ProcessingException {
        if (searchForm == null) {
            return;
        }
        IFormField[] iFormFieldArray = searchForm.getAllFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField field = iFormFieldArray[n2];
            if (field instanceof IValueField) {
                this.setSubTitle(String.valueOf(StringUtility.join((String)" > ", (String[])new String[]{StringUtility.nvl((Object)searchForm.getTitle(), (String)searchForm.getClass().getSimpleName()), field.getLabel()})) + " [" + field.getClass().getSimpleName() + "]");
                try {
                    searchForm.doReset();
                    try {
                        this.fillMandatoryFields(searchForm);
                        if (this.fillValueField((IValueField)field)) {
                            searchForm.doSaveWithoutMarkerChange();
                            this.addOkStatus(null);
                        }
                    }
                    catch (VetoException vetoException) {
                        this.addWarningStatus("Veto", null);
                    }
                }
                catch (Throwable t) {
                    this.addErrorStatus(t.getMessage(), t);
                }
            } else if (field instanceof IComposerField) {
                this.testComposerField(searchForm, (IComposerField)field);
            }
            ++n2;
        }
    }

    protected void testComposerField(ISearchForm searchForm, IComposerField field) {
    }

    protected void fillMandatoryFields(ISearchForm searchForm) throws ProcessingException {
        if (searchForm == null) {
            return;
        }
        IFormField[] iFormFieldArray = searchForm.getAllFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField field = iFormFieldArray[n2];
            if (field instanceof IValueField && ((IValueField)field).isMandatory()) {
                this.fillValueField((IValueField)field);
            }
            ++n2;
        }
    }

    protected boolean fillValueField(IValueField<?> field) throws ProcessingException {
        boolean successful = false;
        if (field.isEnabled() && field.isVisible()) {
            if (field instanceof IBooleanField) {
                successful = this.fillBooleanField((IBooleanField)field);
            } else if (field instanceof IDateField) {
                successful = this.fillDateField((IDateField)field);
            } else if (field instanceof IBigDecimalField) {
                successful = this.fillBigDecimalField((IBigDecimalField)field);
            } else if (field instanceof IDoubleField) {
                successful = this.fillDoubleField((IDoubleField)field);
            } else if (field instanceof IListBox) {
                successful = this.fillListBox((IListBox)field);
            } else if (field instanceof IBigIntegerField) {
                successful = this.fillBigIntegerField((IBigIntegerField)field);
            } else if (field instanceof IIntegerField) {
                successful = this.fillIntegerField((IIntegerField)field);
            } else if (field instanceof ILongField) {
                successful = this.fillLongField((ILongField)field);
            } else if (field instanceof IRadioButtonGroup) {
                successful = this.fillRadioButtonGroup((IRadioButtonGroup)field);
            } else if (field instanceof ISmartField) {
                successful = this.fillSmartField((ISmartField)field);
            } else if (field instanceof IStringField) {
                successful = this.fillStringField((IStringField)field);
            } else if (field instanceof ITreeBox) {
                successful = this.fillTreeBox((ITreeBox)field);
            } else {
                return false;
            }
        }
        return successful && field.isContentValid();
    }

    protected boolean fillBooleanField(IBooleanField field) {
        field.setValue(true);
        return field.isContentValid();
    }

    protected boolean fillDateField(IDateField field) {
        if (field.isHasTime()) {
            field.setValue(new Date());
        } else {
            field.setValue(DateUtility.truncDate((Date)new Date()));
        }
        return field.isContentValid();
    }

    protected boolean fillBigDecimalField(IBigDecimalField field) {
        BigDecimal value = (BigDecimal)field.getMinValue();
        if (value == null) {
            value = (BigDecimal)field.getMaxValue();
        }
        if (value == null) {
            value = BigDecimal.ONE;
        }
        field.setValue(value);
        return field.isContentValid();
    }

    protected boolean fillDoubleField(IDoubleField field) {
        Double value = (Double)field.getMinValue();
        if (value == null) {
            value = (Double)field.getMaxValue();
        }
        if (value == null) {
            value = 1.2345;
        }
        if (value == (double)value.longValue()) {
            value = value + 0.2345;
        }
        field.setValue(value);
        return true;
    }

    protected boolean fillListBox(IListBox field) {
        ITable table = field.getTable();
        if (table.getRowCount() > 0) {
            ITableRow[] iTableRowArray = table.getRows();
            int n = iTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] keyValues;
                ITableRow row = iTableRowArray[n2];
                if (row.isEnabled() && (keyValues = row.getKeyValues()).length > 0) {
                    field.checkKey(keyValues[0]);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean fillBigIntegerField(IBigIntegerField field) {
        BigInteger value = (BigInteger)field.getMinValue();
        if (value == null) {
            value = (BigInteger)field.getMaxValue();
        }
        if (value == null) {
            value = BigInteger.ONE;
        }
        field.setValue(value);
        return true;
    }

    protected boolean fillIntegerField(IIntegerField field) {
        Integer value = (Integer)field.getMinValue();
        if (value == null) {
            value = (Integer)field.getMaxValue();
        }
        if (value == null) {
            value = 42;
        }
        field.setValue(value);
        return true;
    }

    protected boolean fillLongField(ILongField field) {
        Long value = (Long)field.getMinValue();
        if (value == null) {
            value = (Long)field.getMaxValue();
        }
        if (value == null) {
            value = 192L;
        }
        field.setValue(value);
        return true;
    }

    protected boolean fillRadioButtonGroup(IRadioButtonGroup field) throws ProcessingException {
        IButton[] buttons = field.getButtons();
        if (buttons != null) {
            IButton[] iButtonArray = buttons;
            int n = buttons.length;
            int n2 = 0;
            while (n2 < n) {
                IButton button = iButtonArray[n2];
                if (button.isVisible() && button.isEnabled()) {
                    button.doClick();
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean fillSmartField(ISmartField field) throws ProcessingException {
        LookupRow[] lookupRows = field.callBrowseLookup(null, 10);
        if (lookupRows != null && lookupRows.length > 0) {
            field.setValue(lookupRows[0].getKey());
            return true;
        }
        return false;
    }

    protected boolean fillStringField(IStringField field) {
        field.setValue("abcd1234");
        return field.isContentValid();
    }

    protected boolean fillTreeBox(ITreeBox field) throws ProcessingException {
        ITreeNode node = this.getFirstSelectableNode(field.getTree().getRootNode());
        if (node != null) {
            field.setValue(node.getPrimaryKey());
            return true;
        }
        return false;
    }

    protected ITreeNode getFirstSelectableNode(ITreeNode ... nodes) {
        if (nodes != null) {
            ITreeNode[] iTreeNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode node = iTreeNodeArray[n2];
                if (node != null) {
                    if (node.isEnabled() && node.isVisible() && node.getParentNode() != null) {
                        return node;
                    }
                    ITreeNode selecteableNode = this.getFirstSelectableNode(node.getChildNodes());
                    if (selecteableNode != null) {
                        return selecteableNode;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    protected String getConfiguredTitle() {
        return "outline drill-down";
    }

    private static class P_LimitingResultSetSearchFormListener
    implements FormListener {
        final ISearchForm searchForm;

        public P_LimitingResultSetSearchFormListener(ISearchForm searchForm) {
            this.searchForm = searchForm;
        }

        @Override
        public void formChanged(FormEvent e) throws ProcessingException {
            e.getType();
        }
    }
}

