/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace.translationFile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.ITranslationFile;

public class TranslationFileEvent {
    public static final int TYPE_ENTRY_ADD = 1;
    public static final int TYPE_ENTRY_REMOVE = 2;
    public static final int TYPE_ENTRY_MODIFY = 4;
    public static final int TYPE_FILE_REMOVED = 1024;
    private List<TranslationFileEvent> m_subEvents;
    private int m_type;
    private String m_translation;
    private String m_key;
    private final ITranslationFile m_source;

    public TranslationFileEvent(ITranslationFile source) {
        this.m_source = source;
        this.m_subEvents = new ArrayList<TranslationFileEvent>();
    }

    public TranslationFileEvent(ITranslationFile source, int type) {
        this.m_source = source;
        this.m_type = type;
    }

    public TranslationFileEvent(ITranslationFile source, String key, String translation, int type) {
        this.m_source = source;
        this.m_key = key;
        this.m_translation = translation;
        this.m_type = type;
    }

    public ITranslationFile getSource() {
        return this.m_source;
    }

    public boolean isMulti() {
        return this.m_subEvents != null;
    }

    public void addEvent(TranslationFileEvent event) {
        this.m_subEvents.add(event);
    }

    public boolean removeEvent(TranslationFileEvent event) {
        return this.m_subEvents.remove(event);
    }

    public TranslationFileEvent[] getSubEvents() {
        if (this.m_subEvents == null) {
            return new TranslationFileEvent[0];
        }
        return this.m_subEvents.toArray(new TranslationFileEvent[this.m_subEvents.size()]);
    }

    public int getType() {
        return this.m_type;
    }

    public String getTranslation() {
        return this.m_translation;
    }

    public String getKey() {
        return this.m_key;
    }
}

