/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.model.workspace.translationFile.ITranslationFile;

public class NlsProjectEvent {
    public static final int TYPE_ENTRY_ADDED = 1;
    public static final int TYPE_ENTRY_REMOVEED = 2;
    public static final int TYPE_ENTRY_MODIFYED = 4;
    public static final int TYPE_REFRESH = 8;
    public static final int TYPE_FULL_REFRESH = 16;
    public static final int TYPE_TRANSLATION_FILE_ADDED = 32;
    public static final int TYPE_TRANSLATION_FILE_REMOVED = 64;
    private final INlsProject m_source;
    private INlsEntry m_entry;
    private int m_type;
    private List<NlsProjectEvent> m_childEvents;
    private ITranslationFile m_file;

    public NlsProjectEvent(INlsProject source) {
        this.m_source = source;
        this.m_childEvents = new ArrayList<NlsProjectEvent>();
    }

    public NlsProjectEvent(INlsProject source, int type) {
        this.m_source = source;
        this.m_type = type;
    }

    public NlsProjectEvent(INlsProject source, ITranslationFile file, int type) {
        this.m_source = source;
        this.m_file = file;
    }

    public NlsProjectEvent(INlsProject source, INlsEntry entry, int type) {
        this.m_source = source;
        this.m_entry = entry;
        this.m_type = type;
    }

    public boolean isMultiEvent() {
        return this.m_childEvents != null;
    }

    public void addChildEvent(NlsProjectEvent event) {
        Assert.isNotNull(this.m_childEvents);
        this.m_childEvents.add(event);
    }

    public void removeChildEvent(NlsProjectEvent event) {
        Assert.isNotNull(this.m_childEvents);
        this.m_childEvents.remove(event);
    }

    public NlsProjectEvent[] getChildEvents() {
        if (this.m_childEvents == null) {
            return new NlsProjectEvent[0];
        }
        return this.m_childEvents.toArray(new NlsProjectEvent[this.m_childEvents.size()]);
    }

    public INlsProject getSource() {
        return this.m_source;
    }

    public INlsEntry getEntry() {
        return this.m_entry;
    }

    public int getType() {
        return this.m_type;
    }

    public ITranslationFile getFile() {
        return this.m_file;
    }
}

