/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.parsers.token;

import org.eclipse.scout.commons.parsers.token.IToken;

public class ValueInputToken
implements IToken {
    private String m_parsedToken;
    private String m_parsedOp;
    private String m_parsedAttribute;
    private String m_replaceToken;
    private String m_name;
    private boolean m_plainValue;
    private boolean m_plainSql;
    private boolean m_batch;

    public ValueInputToken(String parsedToken, String name, boolean plainValue, boolean plainSql) {
        this.m_parsedToken = parsedToken;
        this.m_name = name;
        this.m_plainValue = plainValue;
        this.m_plainSql = plainSql;
        if (name.startsWith("{") && name.endsWith("}")) {
            this.m_name = this.m_name.substring(1, this.m_name.length() - 1);
            this.m_batch = true;
        }
    }

    @Override
    public boolean isInput() {
        return true;
    }

    @Override
    public boolean isOutput() {
        return false;
    }

    @Override
    public String getParsedToken() {
        return this.m_parsedToken;
    }

    @Override
    public String getReplaceToken() {
        if (this.m_replaceToken != null) {
            return this.m_replaceToken;
        }
        return this.m_parsedToken;
    }

    @Override
    public void setReplaceToken(String s) {
        this.m_replaceToken = s;
    }

    public String getParsedOp() {
        return this.m_parsedOp;
    }

    public void setParsedOp(String s) {
        this.m_parsedOp = s;
    }

    public String getParsedAttribute() {
        return this.m_parsedAttribute;
    }

    public void setParsedAttribute(String s) {
        this.m_parsedAttribute = s;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isPlainValue() {
        return this.m_plainValue;
    }

    public void setPlainValue(boolean b) {
        this.m_plainValue = b;
    }

    public boolean isPlainSql() {
        return this.m_plainSql;
    }

    public void setPlainSql(boolean b) {
        this.m_plainSql = b;
    }

    public boolean isBatch() {
        return this.m_batch;
    }

    public void setBatch(boolean b) {
        this.m_batch = b;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(String.valueOf(this.getClass().getSimpleName()) + "[");
        b.append("parsed '");
        if (this.getParsedAttribute() != null) {
            b.append(this.getParsedAttribute());
            b.append(" ");
        }
        if (this.getParsedOp() != null) {
            b.append(this.getParsedOp());
            b.append(" ");
        }
        b.append(this.getParsedToken());
        b.append("'");
        b.append(", replaced '");
        if (this.getParsedAttribute() != null) {
            b.append(this.getParsedAttribute());
            b.append(" ");
        }
        if (this.getParsedOp() != null) {
            b.append(this.getParsedOp());
            b.append(" ");
        }
        b.append(this.getReplaceToken());
        b.append("'");
        if (this.isBatch()) {
            b.append(" batch");
        }
        if (this.isPlainSql()) {
            b.append(" plainSql");
        }
        if (this.isPlainValue()) {
            b.append(" plainValue");
        }
        b.append("]");
        return b.toString();
    }
}

