/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.nls;

import java.util.Locale;
import org.eclipse.scout.commons.LocaleThreadLocal;

public final class NlsLocale {
    private Locale m_locale;
    private static NlsLocale nlsLocale;
    private static ThreadLocal<NlsLocale> nlsLocaleThreadLocal;

    static {
        nlsLocaleThreadLocal = new ThreadLocal();
    }

    public NlsLocale() {
        this(null);
    }

    public NlsLocale(Locale l) {
        if (l == null) {
            l = Locale.getDefault();
        }
        this.m_locale = l;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public int hashCode() {
        return this.m_locale.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof NlsLocale && ((NlsLocale)o).m_locale.equals(this.m_locale);
    }

    public String toString() {
        return this.m_locale.toString();
    }

    public static NlsLocale getDefault() {
        Locale formattingLocale;
        NlsLocale l = nlsLocaleThreadLocal.get();
        if (l == null) {
            l = nlsLocale;
        }
        if (l == null && (formattingLocale = LocaleThreadLocal.get()) != null) {
            l = new NlsLocale(formattingLocale);
        }
        if (l == null) {
            l = new NlsLocale(Locale.getDefault());
        }
        return l;
    }

    public static void setDefault(NlsLocale l) {
        nlsLocale = l;
    }

    public static void setThreadDefault(NlsLocale l) {
        nlsLocaleThreadLocal.set(l);
    }
}

