/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.dnd;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.dnd.TransferObject;

public class FileListTransferObject
extends TransferObject {
    private File[] m_files;

    public FileListTransferObject(File ... files) {
        this.m_files = files == null ? new File[0] : files;
    }

    public FileListTransferObject(Collection<File> files) {
        this.m_files = files == null ? new File[0] : files.toArray(new File[0]);
    }

    @Override
    public boolean isFileList() {
        return true;
    }

    public File[] getFiles() {
        return this.m_files;
    }

    public List<File> getFileList() {
        return Arrays.asList(this.m_files);
    }

    public String[] getFilenames() {
        return this.getFilenameList();
    }

    public String[] getFilenameList() {
        String[] list = new String[this.m_files.length];
        int i = 0;
        while (i < this.m_files.length) {
            list[i] = this.m_files[i].getAbsolutePath();
            ++i;
        }
        return list;
    }

    public String toString() {
        return "FileListTransferObject[files=" + Arrays.toString(this.m_files) + "]";
    }
}

