/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.ServiceStore;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FakeContextUtil {
    private static final ClassLoader CLASS_LOADER = FakeContextUtil.class.getClassLoader();
    private static final HttpServletResponse RESPONSE_PROXY = FakeContextUtil.newResponse();
    private static final Class<?> REQUEST_PROXY_CLASS = FakeContextUtil.getRequestProxyClass();

    private FakeContextUtil() {
    }

    public static void runNonUIThreadWithFakeContext(Display display, Runnable runnable) {
        boolean useFakeContext;
        Display sessionDisplay = LifeCycleUtil.getSessionDisplay();
        boolean useDifferentContext = ContextProvider.hasContext() && sessionDisplay != display;
        ServiceContext contextBuffer = null;
        boolean wasMapped = false;
        if (useDifferentContext) {
            contextBuffer = ContextProvider.getContext();
            wasMapped = ContextProvider.releaseContextHolder();
        }
        boolean bl = useFakeContext = !ContextProvider.hasContext();
        if (useFakeContext) {
            IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
            ISessionStore session = adapter.getSessionStore();
            ContextProvider.setContext(FakeContextUtil.createFakeContext(session));
        }
        try {
            runnable.run();
        }
        finally {
            if (useFakeContext) {
                ContextProvider.disposeContext();
            }
            if (useDifferentContext) {
                if (wasMapped) {
                    ContextProvider.setContext(contextBuffer, Thread.currentThread());
                } else {
                    ContextProvider.setContext(contextBuffer);
                }
            }
        }
    }

    public static ServiceContext createFakeContext(ISessionStore sessionStore) {
        HttpServletRequest request = FakeContextUtil.newRequest(sessionStore);
        ServiceContext result = new ServiceContext(request, RESPONSE_PROXY, sessionStore);
        result.setServiceStore(new ServiceStore());
        return result;
    }

    private static HttpServletRequest newRequest(ISessionStore sessionStore) {
        RequestInvocationHandler invocationHandler = new RequestInvocationHandler(sessionStore);
        Class[] paramTypes = new Class[]{InvocationHandler.class};
        Object[] paramValues = new Object[]{invocationHandler};
        Object proxy = ClassUtil.newInstance(REQUEST_PROXY_CLASS, paramTypes, paramValues);
        return (HttpServletRequest)proxy;
    }

    private static Class<?> getRequestProxyClass() {
        return Proxy.getProxyClass(CLASS_LOADER, HttpServletRequest.class);
    }

    private static HttpServletResponse newResponse() {
        Class[] interfaces = new Class[]{HttpServletResponse.class};
        ResponseInvocationHandler invocationHandler = new ResponseInvocationHandler();
        Object proxy = Proxy.newProxyInstance(CLASS_LOADER, interfaces, (InvocationHandler)invocationHandler);
        return (HttpServletResponse)proxy;
    }

    private static class RequestInvocationHandler
    implements InvocationHandler {
        private final ISessionStore sessionStore;

        RequestInvocationHandler(ISessionStore sessionStore) {
            this.sessionStore = sessionStore;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            HttpSession result;
            if ("getSession".equals(method.getName())) {
                result = this.sessionStore.getHttpSession();
            } else if ("getLocale".equals(method.getName())) {
                result = null;
            } else {
                throw new UnsupportedOperationException();
            }
            return result;
        }
    }

    private static final class ResponseInvocationHandler
    implements InvocationHandler {
        private ResponseInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new UnsupportedOperationException();
        }
    }
}

