/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.clientscripting.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ResourceLoaderUtil {
    private static final String CHARSET = "UTF-8";
    private static final ClassLoader CLASSLOADER = ResourceLoaderUtil.class.getClassLoader();

    private ResourceLoaderUtil() {
    }

    public static String readTextContent(String resource) {
        try {
            return ResourceLoaderUtil.readTextContentChecked(resource);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to read resource: " + resource);
        }
    }

    private static String readTextContentChecked(String resource) throws IOException {
        InputStream stream = CLASSLOADER.getResourceAsStream(resource);
        if (stream == null) {
            throw new IllegalArgumentException("Resource not found: " + resource);
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, CHARSET));
            String string = ResourceLoaderUtil.readLines(reader);
            return string;
        }
        finally {
            stream.close();
        }
    }

    private static String readLines(BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            builder.append(line);
            builder.append('\n');
            line = reader.readLine();
        }
        return builder.toString();
    }
}

