/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.chart.basic;

import org.eclipse.rap.addons.chart.NvChart;
import org.eclipse.rap.addons.chart.basic.DataItem;
import org.eclipse.rap.addons.chart.internal.ColorUtil;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.swt.widgets.Composite;

public class PieChart
extends NvChart {
    private boolean showLabels = true;
    private boolean labelsOutside;
    private boolean growOnHover = true;
    private boolean labelSunbeamLayout;
    private double labelThreshold = 0.02;
    private String labelType = "key";
    private String legendPosition = "top";

    public PieChart(Composite parent, int style) {
        super(parent, style, "nv-pie");
        this.requireJs(this.registerResource("chart/nv/nv-pie.js"));
    }

    public void setShowLabels(boolean show) {
        this.checkWidget();
        if (show != this.showLabels) {
            this.showLabels = show;
            this.setOption("showLabels", show);
        }
    }

    public boolean getShowLabels() {
        this.checkWidget();
        return this.showLabels;
    }

    public void setLabelsOutside(boolean labelsOutside) {
        this.checkWidget();
        if (this.labelsOutside != labelsOutside) {
            this.labelsOutside = labelsOutside;
            this.setOption("labelsOutside", labelsOutside);
        }
    }

    public boolean getLabelsOutside() {
        this.checkWidget();
        return this.labelsOutside;
    }

    public void setGrowOnHover(boolean growOnHover) {
        this.checkWidget();
        if (this.growOnHover != growOnHover) {
            this.growOnHover = growOnHover;
            this.setOption("growOnHover", growOnHover);
        }
    }

    public boolean getGrowOnHover() {
        this.checkWidget();
        return this.growOnHover;
    }

    public void setLabelSunbeamLayout(boolean labelSunbeamLayout) {
        this.checkWidget();
        if (this.labelSunbeamLayout != labelSunbeamLayout) {
            this.labelSunbeamLayout = labelSunbeamLayout;
            this.setOption("labelSunbeamLayout", labelSunbeamLayout);
        }
    }

    public boolean getLabelSunbeamLayout() {
        this.checkWidget();
        return this.labelSunbeamLayout;
    }

    public void setLabelThreshold(double labelThreshold) {
        this.checkWidget();
        if (this.labelThreshold != labelThreshold) {
            this.labelThreshold = labelThreshold;
            this.setOption("labelThreshold", labelThreshold);
        }
    }

    public double getLabelThreshold() {
        this.checkWidget();
        return this.labelThreshold;
    }

    public void setLabelType(String labelType) {
        this.checkWidget();
        if (labelType != null && !labelType.equals(this.labelType)) {
            this.labelType = labelType;
            this.setOption("labelType", labelType);
        }
    }

    public String getLabelType() {
        this.checkWidget();
        return this.labelType;
    }

    public void setLegendPosition(String legendPosition) {
        this.checkWidget();
        if (legendPosition != null && !legendPosition.equals(this.legendPosition)) {
            this.legendPosition = legendPosition;
            this.setOption("legendPosition", legendPosition);
        }
    }

    public String getLegendPosition() {
        this.checkWidget();
        return this.legendPosition;
    }

    public void setItems(DataItem ... items) {
        JsonArray values = new JsonArray();
        DataItem[] dataItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            DataItem item = dataItemArray[n2];
            values.add((JsonValue)PieChart.toJson(item));
            ++n2;
        }
        this.setItems((JsonValue)values);
    }

    private static JsonObject toJson(DataItem item) {
        JsonObject json = new JsonObject().add("value", item.value);
        if (item.text != null) {
            json.add("label", item.text);
        }
        if (item.color != null) {
            json.add("color", ColorUtil.toHtmlString(item.color));
        }
        return json;
    }
}

