/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.internal.IScrollBarProxy;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public class ScrollBarProxyAdapter
implements IScrollBarProxy {
    private ScrollBar scrollBar;
    private int increment;
    private int pageIncrement;

    public ScrollBarProxyAdapter(ScrollBar scrollBar) {
        this.scrollBar = scrollBar;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getMaximum() {
        return this.scrollBar.getMaximum();
    }

    public int getMinimum() {
        return this.scrollBar.getMinimum();
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public int getSelection() {
        return this.scrollBar.getSelection();
    }

    public int getThumb() {
        return this.scrollBar.getThumb();
    }

    public boolean getVisible() {
        return this.scrollBar.getVisible();
    }

    public void setIncrement(int value) {
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.scrollBar.setMaximum(value);
    }

    public void setMinimum(int value) {
        this.scrollBar.setMinimum(value);
    }

    public void setPageIncrement(int value) {
        this.pageIncrement = value;
    }

    public void setSelection(int selection) {
        int minimum = this.scrollBar.getMinimum();
        int maximum = this.scrollBar.getMaximum();
        int thumb = this.scrollBar.getThumb();
        if (selection < minimum) {
            this.scrollBar.setSelection(minimum);
        } else if (selection > maximum - thumb) {
            this.scrollBar.setSelection(maximum - thumb);
        } else {
            this.scrollBar.setSelection(selection);
        }
    }

    public void setThumb(int value) {
        this.scrollBar.setThumb(value);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        if (selection >= minimum && selection <= maximum) {
            this.scrollBar.setSelection(selection);
        }
        if (minimum >= 0 && minimum < maximum) {
            this.scrollBar.setMinimum(minimum);
            if (selection < minimum) {
                this.scrollBar.setSelection(minimum);
            }
        }
        if (minimum >= 0 && minimum < maximum) {
            this.scrollBar.setMaximum(maximum);
            if (selection > maximum - thumb) {
                this.scrollBar.setSelection(maximum - thumb);
            }
        }
        if (thumb >= 1) {
            this.scrollBar.setThumb(thumb);
        }
        if (increment >= 1 && increment <= maximum - minimum) {
            this.increment = increment;
        }
        if (pageIncrement >= 1 && pageIncrement <= maximum - minimum) {
            this.pageIncrement = pageIncrement;
        }
        if (thumb >= maximum - minimum) {
            this.scrollBar.setThumb(maximum - minimum);
            this.scrollBar.setSelection(minimum);
        }
    }

    public void setVisible(boolean visible) {
        this.scrollBar.setVisible(visible);
    }

    public void handleMouseWheel(Event e) {
    }

    public void addSelectionListener(SelectionListener listener) {
        this.scrollBar.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.scrollBar.removeSelectionListener(listener);
    }
}

