/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Localizer;

public class JavacErrorDetail {
    private String javaFileName;
    private int javaLineNum;
    private String jspFileName;
    private int jspBeginLineNum;
    private StringBuilder errMsg;
    private String jspExtract;

    public JavacErrorDetail(String javaFileName, int javaLineNum, StringBuilder errMsg) {
        this.jspExtract = null;
        this.javaFileName = javaFileName;
        this.javaLineNum = javaLineNum;
        this.errMsg = errMsg;
        this.jspBeginLineNum = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JavacErrorDetail(String javaFileName, int javaLineNum, String jspFileName, int jspBeginLineNum, StringBuilder errMsg, JspCompilationContext ctxt) {
        String[] javaLines;
        String[] jspLines;
        FileInputStream fis;
        InputStream is;
        block28: {
            block29: {
                this(javaFileName, javaLineNum, errMsg);
                this.jspFileName = jspFileName;
                this.jspBeginLineNum = jspBeginLineNum;
                if (jspBeginLineNum <= 0 || ctxt == null) return;
                is = null;
                fis = null;
                is = ctxt.getResourceAsStream(jspFileName);
                jspLines = this.readFile(is);
                fis = new FileInputStream(ctxt.getServletJavaFileName());
                javaLines = this.readFile(fis);
                if (jspLines.length >= jspBeginLineNum) break block28;
                this.jspExtract = Localizer.getMessage("jsp.error.bug48498");
                if (is == null) break block29;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (fis == null) return;
            try {
                fis.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                if (jspLines[jspBeginLineNum - 1].lastIndexOf("<%") > jspLines[jspBeginLineNum - 1].lastIndexOf("%>")) {
                    String javaLine = javaLines[javaLineNum - 1].trim();
                    int i = jspBeginLineNum - 1;
                    while (i < jspLines.length) {
                        if (jspLines[i].indexOf(javaLine) != -1) {
                            this.jspBeginLineNum = i + 1;
                            break;
                        }
                        ++i;
                    }
                }
                StringBuilder fragment = new StringBuilder(1024);
                int startIndex = Math.max(0, this.jspBeginLineNum - 1 - 3);
                int endIndex = Math.min(jspLines.length - 1, this.jspBeginLineNum - 1 + 3);
                int i = startIndex;
                while (i <= endIndex) {
                    fragment.append(i + 1);
                    fragment.append(": ");
                    fragment.append(jspLines[i]);
                    fragment.append(Constants.NEWLINE);
                    ++i;
                }
                this.jspExtract = fragment.toString();
            }
            catch (IOException iOException) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException iOException3) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public String getJavaFileName() {
        return this.javaFileName;
    }

    public int getJavaLineNumber() {
        return this.javaLineNum;
    }

    public String getJspFileName() {
        return this.jspFileName;
    }

    public int getJspBeginLineNumber() {
        return this.jspBeginLineNum;
    }

    public String getErrorMessage() {
        return this.errMsg.toString();
    }

    public String getJspExtract() {
        return this.jspExtract;
    }

    private String[] readFile(InputStream s) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(s));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines.toArray(new String[lines.size()]);
    }
}

