/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class RequestUtil {
    private static final Log log = LogFactory.getLog(RequestUtil.class);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.util");
    private static SimpleDateFormat format = new SimpleDateFormat(" EEEE, dd-MMM-yy kk:mm:ss zz");

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        int i = 0;
        while (i < content.length) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                default: {
                    result.append(content[i]);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String normalize(String path) {
        return RequestUtil.normalize(path, true);
    }

    public static String normalize(String path, boolean replaceBackSlash) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (replaceBackSlash && normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static void parseParameters(Map<String, String[]> map, String data, String encoding) {
        if (data != null && data.length() > 0) {
            byte[] bytes = null;
            try {
                bytes = encoding == null ? data.getBytes() : data.getBytes(encoding);
                RequestUtil.parseParameters(map, bytes, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                log.debug(sm.getString("requestUtil.parseParameters.uee", encoding), uee);
            }
        }
    }

    public static String URLDecode(String str) {
        return RequestUtil.URLDecode(str, null);
    }

    public static String URLDecode(String str, String enc) {
        return RequestUtil.URLDecode(str, enc, false);
    }

    public static String URLDecode(String str, String enc, boolean isQuery) {
        if (str == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = enc == null ? str.getBytes() : str.getBytes(enc);
        }
        catch (UnsupportedEncodingException uee) {
            log.debug(sm.getString("requestUtil.urlDecode.uee", enc), uee);
        }
        return RequestUtil.URLDecode(bytes, enc, isQuery);
    }

    public static String URLDecode(byte[] bytes) {
        return RequestUtil.URLDecode(bytes, null);
    }

    public static String URLDecode(byte[] bytes, String enc) {
        return RequestUtil.URLDecode(bytes, enc, false);
    }

    public static String URLDecode(byte[] bytes, String enc, boolean isQuery) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        int ix = 0;
        int ox = 0;
        while (ix < len) {
            int b;
            if ((b = bytes[ix++]) == 43 && isQuery) {
                b = 32;
            } else if (b == 37) {
                if (ix + 2 > len) {
                    throw new IllegalArgumentException(sm.getString("requestUtil.urlDecode.missingDigit"));
                }
                b = (byte)((RequestUtil.convertHexDigit(bytes[ix++]) << 4) + RequestUtil.convertHexDigit(bytes[ix++]));
            }
            bytes[ox++] = b;
        }
        if (enc != null) {
            try {
                return new String(bytes, 0, ox, enc);
            }
            catch (UnsupportedEncodingException uee) {
                log.debug(sm.getString("requestUtil.urlDecode.uee", enc), uee);
                return null;
            }
        }
        return new String(bytes, 0, ox);
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        throw new IllegalArgumentException(sm.getString("requestUtil.convertHexDigit.notHex", Character.valueOf((char)b)));
    }

    private static void putMapEntry(Map<String, String[]> map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    public static void parseParameters(Map<String, String[]> map, byte[] data, String encoding) throws UnsupportedEncodingException {
        if (data != null && data.length > 0) {
            int ix = 0;
            int ox = 0;
            String key = null;
            String value = null;
            while (ix < data.length) {
                byte c = data[ix++];
                switch ((char)c) {
                    case '&': {
                        value = new String(data, 0, ox, encoding);
                        if (key != null) {
                            RequestUtil.putMapEntry(map, key, value);
                            key = null;
                        }
                        ox = 0;
                        break;
                    }
                    case '=': {
                        if (key == null) {
                            key = new String(data, 0, ox, encoding);
                            ox = 0;
                            break;
                        }
                        data[ox++] = c;
                        break;
                    }
                    case '+': {
                        data[ox++] = 32;
                        break;
                    }
                    case '%': {
                        data[ox++] = (byte)((RequestUtil.convertHexDigit(data[ix++]) << 4) + RequestUtil.convertHexDigit(data[ix++]));
                        break;
                    }
                    default: {
                        data[ox++] = c;
                    }
                }
            }
            if (key != null) {
                value = new String(data, 0, ox, encoding);
                RequestUtil.putMapEntry(map, key, value);
            }
        }
    }
}

