/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.modeler.BaseModelMBean;

public class ContainerMBean
extends BaseModelMBean {
    public void addChild(String type, String name) throws MBeanException {
        Container contained = null;
        try {
            LifecycleListener config;
            contained = (Container)Class.forName(type).newInstance();
            contained.setName(name);
            if (contained instanceof StandardHost) {
                config = new HostConfig();
                contained.addLifecycleListener(config);
            } else if (contained instanceof StandardContext) {
                config = new ContextConfig();
                contained.addLifecycleListener(config);
            }
        }
        catch (InstantiationException e) {
            throw new MBeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MBeanException(e);
        }
        boolean oldValue = true;
        ContainerBase container = null;
        try {
            try {
                container = (ContainerBase)this.getManagedResource();
                oldValue = container.getStartChildren();
                container.setStartChildren(false);
                container.addChild(contained);
                contained.init();
            }
            catch (InstanceNotFoundException e) {
                throw new MBeanException(e);
            }
            catch (RuntimeOperationsException e) {
                throw new MBeanException(e);
            }
            catch (InvalidTargetObjectTypeException e) {
                throw new MBeanException(e);
            }
            catch (LifecycleException e) {
                throw new MBeanException(e);
            }
        }
        finally {
            if (container != null) {
                container.setStartChildren(oldValue);
            }
        }
    }

    public void removeChild(String name) throws MBeanException {
        if (name != null) {
            try {
                Container container = (Container)this.getManagedResource();
                Container contained = container.findChild(name);
                container.removeChild(contained);
            }
            catch (InstanceNotFoundException e) {
                throw new MBeanException(e);
            }
            catch (RuntimeOperationsException e) {
                throw new MBeanException(e);
            }
            catch (InvalidTargetObjectTypeException e) {
                throw new MBeanException(e);
            }
        }
    }

    public String addValve(String valveType) throws MBeanException {
        Valve valve = null;
        try {
            valve = (Valve)Class.forName(valveType).newInstance();
        }
        catch (InstantiationException e) {
            throw new MBeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MBeanException(e);
        }
        if (valve == null) {
            return null;
        }
        try {
            ContainerBase container = (ContainerBase)this.getManagedResource();
            container.addValve(valve);
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (RuntimeOperationsException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        return ((LifecycleMBeanBase)((Object)valve)).getObjectName().toString();
    }

    public void removeValve(String valveName) throws MBeanException {
        ObjectName oname;
        ContainerBase container = null;
        try {
            container = (ContainerBase)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (RuntimeOperationsException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        try {
            oname = new ObjectName(valveName);
        }
        catch (MalformedObjectNameException e) {
            throw new MBeanException(e);
        }
        catch (NullPointerException e) {
            throw new MBeanException(e);
        }
        if (container != null) {
            Valve[] valves = container.getPipeline().getValves();
            int i = 0;
            while (i < valves.length) {
                ObjectName voname = ((ValveBase)valves[i]).getObjectName();
                if (voname.equals(oname)) {
                    container.getPipeline().removeValve(valves[i]);
                }
                ++i;
            }
        }
    }

    public void addLifeCycleListener(String type) throws MBeanException {
        LifecycleListener listener = null;
        try {
            listener = (LifecycleListener)Class.forName(type).newInstance();
        }
        catch (InstantiationException e) {
            throw new MBeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MBeanException(e);
        }
        if (listener != null) {
            try {
                ContainerBase container = (ContainerBase)this.getManagedResource();
                container.addLifecycleListener(listener);
            }
            catch (InstanceNotFoundException e) {
                throw new MBeanException(e);
            }
            catch (RuntimeOperationsException e) {
                throw new MBeanException(e);
            }
            catch (InvalidTargetObjectTypeException e) {
                throw new MBeanException(e);
            }
        }
    }

    public void removeLifeCycleListeners(String type) throws MBeanException {
        LifecycleListener[] listeners;
        ContainerBase container = null;
        try {
            container = (ContainerBase)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (RuntimeOperationsException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        LifecycleListener[] lifecycleListenerArray = listeners = container.findLifecycleListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            LifecycleListener listener = lifecycleListenerArray[n2];
            if (listener.getClass().getName().equals(type)) {
                container.removeLifecycleListener(listener);
            }
            ++n2;
        }
    }

    public String[] findLifecycleListenerNames() throws MBeanException {
        LifecycleListener[] listeners;
        ContainerBase container = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            container = (ContainerBase)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (RuntimeOperationsException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        LifecycleListener[] lifecycleListenerArray = listeners = container.findLifecycleListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            LifecycleListener listener = lifecycleListenerArray[n2];
            result.add(listener.getClass().getName());
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] findContainerListenerNames() throws MBeanException {
        ContainerListener[] listeners;
        ContainerBase container = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            container = (ContainerBase)this.getManagedResource();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (RuntimeOperationsException e) {
            throw new MBeanException(e);
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new MBeanException(e);
        }
        ContainerListener[] containerListenerArray = listeners = container.findContainerListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ContainerListener listener = containerListenerArray[n2];
            result.add(listener.getClass().getName());
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }
}

