/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.ParameterMap;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationServletRegistration
implements ServletRegistration.Dynamic {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Wrapper wrapper;
    private Context context;

    public ApplicationServletRegistration(Wrapper wrapper, Context context) {
        this.wrapper = wrapper;
        this.context = context;
    }

    public String getClassName() {
        return this.wrapper.getServletClass();
    }

    public String getInitParameter(String name) {
        return this.wrapper.findInitParameter(name);
    }

    public Map<String, String> getInitParameters() {
        String[] parameterNames;
        ParameterMap<String, String> result = new ParameterMap<String, String>();
        String[] stringArray = parameterNames = this.wrapper.findInitParameters();
        int n = parameterNames.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterName = stringArray[n2];
            result.put(parameterName, this.wrapper.findInitParameter(parameterName));
            ++n2;
        }
        result.setLocked(true);
        return result;
    }

    public String getName() {
        return this.wrapper.getName();
    }

    public boolean setInitParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("applicationFilterRegistration.nullInitParam", name, value));
        }
        if (this.getInitParameter(name) != null) {
            return false;
        }
        this.wrapper.addInitParameter(name, value);
        return true;
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        HashSet<String> conflicts = new HashSet<String>();
        for (Map.Entry<String, String> entry : initParameters.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException(sm.getString("applicationFilterRegistration.nullInitParams", entry.getKey(), entry.getValue()));
            }
            if (this.getInitParameter(entry.getKey()) == null) continue;
            conflicts.add(entry.getKey());
        }
        if (conflicts.isEmpty()) {
            for (Map.Entry<String, String> entry : initParameters.entrySet()) {
                this.setInitParameter(entry.getKey(), entry.getValue());
            }
        }
        return conflicts;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.wrapper.setAsyncSupported(asyncSupported);
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.wrapper.setLoadOnStartup(loadOnStartup);
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.wrapper.setMultipartConfigElement(multipartConfig);
    }

    public void setRunAsRole(String roleName) {
        this.wrapper.setRunAs(roleName);
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(sm.getString("applicationServletRegistration.setServletSecurity.iae", this.getName(), this.context.getName()));
        }
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationServletRegistration.setServletSecurity.ise", this.getName(), this.context.getName()));
        }
        return this.context.addServletSecurity(this, constraint);
    }

    public Set<String> addMapping(String ... urlPatterns) {
        String urlPattern;
        if (urlPatterns == null) {
            return Collections.emptySet();
        }
        HashSet<String> conflicts = new HashSet<String>();
        String[] stringArray = urlPatterns;
        int n = urlPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            urlPattern = stringArray[n2];
            if (this.context.findServletMapping(urlPattern) != null) {
                conflicts.add(urlPattern);
            }
            ++n2;
        }
        if (!conflicts.isEmpty()) {
            return conflicts;
        }
        stringArray = urlPatterns;
        n = urlPatterns.length;
        n2 = 0;
        while (n2 < n) {
            urlPattern = stringArray[n2];
            this.context.addServletMapping(urlPattern, this.wrapper.getName());
            ++n2;
        }
        return Collections.emptySet();
    }

    public Collection<String> getMappings() {
        String[] urlPatterns;
        HashSet<String> result = new HashSet<String>();
        String servletName = this.wrapper.getName();
        String[] stringArray = urlPatterns = this.context.findServletMappings();
        int n = urlPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String urlPattern = stringArray[n2];
            String name = this.context.findServletMapping(urlPattern);
            if (name.equals(servletName)) {
                result.add(urlPattern);
            }
            ++n2;
        }
        return result;
    }

    public String getRunAsRole() {
        return this.wrapper.getRunAs();
    }
}

