/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.ri;

import java.io.StringReader;
import org.eclipse.rap.e4.apache.jxpath.JXPathInvalidSyntaxException;
import org.eclipse.rap.e4.apache.jxpath.ri.Compiler;
import org.eclipse.rap.e4.apache.jxpath.ri.parser.ParseException;
import org.eclipse.rap.e4.apache.jxpath.ri.parser.TokenMgrError;
import org.eclipse.rap.e4.apache.jxpath.ri.parser.XPathParser;

public class Parser {
    private static XPathParser parser = new XPathParser(new StringReader(""));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseExpression(String expression, Compiler compiler) {
        XPathParser xPathParser = parser;
        synchronized (xPathParser) {
            parser.setCompiler(compiler);
            Object expr = null;
            try {
                parser.ReInit(new StringReader(expression));
                expr = parser.parseExpression();
            }
            catch (TokenMgrError e) {
                throw new JXPathInvalidSyntaxException("Invalid XPath: '" + Parser.addEscapes(expression) + "'. Invalid symbol '" + Parser.addEscapes(String.valueOf(e.getCharacter())) + "' " + Parser.describePosition(expression, e.getPosition()));
            }
            catch (ParseException e) {
                throw new JXPathInvalidSyntaxException("Invalid XPath: '" + Parser.addEscapes(expression) + "'. Syntax error " + Parser.describePosition(expression, e.currentToken.beginColumn));
            }
            return expr;
        }
    }

    private static String describePosition(String expression, int position) {
        if (position <= 0) {
            return "at the beginning of the expression";
        }
        if (position >= expression.length()) {
            return "- expression incomplete";
        }
        return "after: '" + Parser.addEscapes(expression.substring(0, position)) + "'";
    }

    private static String addEscapes(String string) {
        return TokenMgrError.addEscapes(string);
    }
}

