/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.engine;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.StartupJson;
import org.eclipse.rap.rwt.internal.service.UISessionBuilder;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.util.HTTP;
import org.eclipse.rap.rwt.service.ServiceHandler;

public class RWTServlet
extends HttpServlet {
    private ApplicationContextImpl applicationContext;

    public String getServletInfo() {
        return "RWT Servlet";
    }

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        this.applicationContext = ApplicationContextImpl.getFrom(servletContext);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RWTServlet.ensureCharacterEncoding(request);
        this.handleRequest(request, response);
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.applicationContext.allowsRequests()) {
            response.sendError(503);
        } else if (request.getPathInfo() == null) {
            this.handleValidRequest(request, response);
        } else if ("/".equals(request.getPathInfo()) && "".equals(request.getServletPath())) {
            this.handleValidRequest(request, response);
        } else {
            response.sendError(404);
        }
    }

    private void handleValidRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServiceContext context = new ServiceContext(request, response, this.applicationContext);
        context.setServiceStore(new ServiceStore());
        ContextProvider.setContext(context);
        try {
            RWTServlet.prepareUISession(context);
            if (RWTServlet.isUIRequest(request) || RWTServlet.isServiceHandlerRequest(request)) {
                this.getServiceHandler().service(request, response);
            } else {
                this.sendStartupContent(request, response);
            }
        }
        finally {
            ContextProvider.disposeContext();
        }
    }

    private ServiceHandler getServiceHandler() {
        return this.applicationContext.getServiceManager().getHandler();
    }

    private static boolean isUIRequest(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && RWTServlet.isContentTypeValid((ServletRequest)request) && !RWTServlet.isServiceHandlerRequest(request);
    }

    private static boolean isServiceHandlerRequest(HttpServletRequest request) {
        return HTTP.getParameter(request, "servicehandler") != null;
    }

    private static boolean isContentTypeValid(ServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.startsWith("application/json");
    }

    private void sendStartupContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            StartupJson.send(response);
        } else {
            this.applicationContext.getStartupPage().send(response);
        }
    }

    private static void prepareUISession(ServiceContext context) {
        HttpServletRequest request = context.getRequest();
        HttpSession httpSession = request.getSession(true);
        String connectionId = HTTP.getParameter(request, "cid");
        if (connectionId != null) {
            context.setUISession(UISessionImpl.getInstanceFromSession(httpSession, connectionId));
        } else if (RWTServlet.isUIRequest(request)) {
            context.setUISession(new UISessionBuilder(context).buildUISession());
        }
    }

    private static void ensureCharacterEncoding(HttpServletRequest request) {
        try {
            String characterEncoding = request.getCharacterEncoding();
            if (characterEncoding == null || characterEncoding.isEmpty()) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }
}

