/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.eclipse.rap.http.servlet.internal.registration.PreprocessorRegistration;
import org.eclipse.rap.http.servlet.internal.servlet.ProxyServlet;

public class PreprocessorChainImpl
implements FilterChain {
    private final ProxyServlet proxyServlet;
    private final List<PreprocessorRegistration> preprocessors;
    private final String alias;
    private final DispatcherType dispatcherType;
    private final int filterCount;
    private int filterIndex = 0;

    public PreprocessorChainImpl(List<PreprocessorRegistration> preprocessors, String alias, DispatcherType dispatcherType, ProxyServlet proxyServlet) {
        this.preprocessors = preprocessors;
        this.alias = alias;
        this.dispatcherType = dispatcherType;
        this.proxyServlet = proxyServlet;
        this.filterCount = preprocessors.size();
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.filterIndex < this.filterCount) {
            PreprocessorRegistration registration = this.preprocessors.get(this.filterIndex++);
            registration.doFilter((HttpServletRequest)request, (HttpServletResponse)response, this);
            return;
        }
        this.proxyServlet.dispatch((HttpServletRequest)request, (HttpServletResponse)response, this.alias, this.dispatcherType);
    }
}

