/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.rap.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.rap.http.servlet.internal.servlet.HttpSessionAdaptor;
import org.eclipse.rap.http.servlet.session.HttpSessionInvalidator;

public class HttpSessionTracker
implements HttpSessionInvalidator {
    private final ConcurrentMap<String, Set<HttpSessionAdaptor>> httpSessionAdaptorsMap = new ConcurrentHashMap<String, Set<HttpSessionAdaptor>>();
    private final HttpServiceRuntimeImpl httpServiceRuntime;

    public HttpSessionTracker(HttpServiceRuntimeImpl httpServiceRuntime) {
        this.httpServiceRuntime = httpServiceRuntime;
    }

    @Override
    public void invalidate(String sessionId, boolean invalidateParent) {
        Set httpSessionAdaptors = (Set)this.httpSessionAdaptorsMap.remove(sessionId);
        if (httpSessionAdaptors == null) {
            return;
        }
        HttpSession parentSession = null;
        for (HttpSessionAdaptor httpSessionAdaptor : httpSessionAdaptors) {
            parentSession = httpSessionAdaptor.getSession();
            httpSessionAdaptor.invalidate();
        }
        if (invalidateParent && parentSession != null) {
            try {
                parentSession.invalidate();
            }
            catch (IllegalStateException ise) {
                this.httpServiceRuntime.debug("Session was already invalidated: " + parentSession.getId(), ise);
            }
        }
    }

    public void addHttpSessionAdaptor(String sessionId, HttpSessionAdaptor httpSessionAdaptor) {
        Set previousHttpSessionAdaptors;
        Set httpSessionAdaptors = (Set)this.httpSessionAdaptorsMap.get(sessionId);
        if (httpSessionAdaptors == null && (previousHttpSessionAdaptors = this.httpSessionAdaptorsMap.putIfAbsent(sessionId, httpSessionAdaptors = Collections.newSetFromMap(new ConcurrentHashMap()))) != null) {
            httpSessionAdaptors = previousHttpSessionAdaptors;
        }
        httpSessionAdaptors.add(httpSessionAdaptor);
    }

    public void clear() {
        if (!this.httpSessionAdaptorsMap.isEmpty()) {
            this.httpServiceRuntime.debug("There are HttpSessionAdaptors left over. There might be a context or session leak!");
        }
    }

    public boolean removeHttpSessionAdaptor(String sessionId, HttpSessionAdaptor httpSessionAdaptor) {
        Set httpSessionAdaptors = (Set)this.httpSessionAdaptorsMap.get(sessionId);
        if (httpSessionAdaptors == null) {
            return false;
        }
        try {
            boolean bl = httpSessionAdaptors.remove(httpSessionAdaptor);
            return bl;
        }
        finally {
            if (httpSessionAdaptors.isEmpty()) {
                this.httpSessionAdaptorsMap.remove(sessionId, httpSessionAdaptors);
            }
        }
    }
}

