/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.rap.rwt.internal.engine.PostDeserialization;
import org.eclipse.rap.rwt.internal.serverpush.ServerPushManager;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TimerExecTask;

class TimerExecScheduler
implements SerializableCompatibility {
    final Display display;
    final ServerPushManager serverPushManager;
    private final Collection<TimerExecTask> tasks;
    private transient Timer timer;

    TimerExecScheduler(Display display) {
        this.display = display;
        this.serverPushManager = ServerPushManager.getInstance();
        this.tasks = new LinkedList<TimerExecTask>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(int milliseconds, Runnable runnable) {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            this.initializeTimer();
            TimerExecTask task = this.findOrAddTask(runnable);
            this.timer.schedule((TimerTask)task, milliseconds);
        }
    }

    void cancel(Runnable runnable) {
        TimerExecTask task = this.findAndRemoveTask(runnable);
        if (task != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            ArrayList<TimerExecTask> tasksToCancel = new ArrayList<TimerExecTask>(this.tasks);
            tasksToCancel.forEach(task -> {
                boolean bl = task.cancel();
            });
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.tasks.clear();
        }
    }

    private void initializeTimer() {
        if (this.timer == null) {
            this.timer = this.createTimer();
        }
    }

    Timer createTimer() {
        return new Timer("RWT timerExec scheduler", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerExecTask findOrAddTask(Runnable runnable) {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            TimerExecTask task2;
            for (TimerExecTask task2 : this.tasks) {
                if (task2.getRunnable() != runnable) continue;
                return task2;
            }
            task2 = this.createTask(runnable);
            this.tasks.add(task2);
            return task2;
        }
    }

    TimerExecTask createTask(Runnable runnable) {
        return new TimerExecTask(this, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerExecTask findAndRemoveTask(Runnable runnable) {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            for (TimerExecTask task : this.tasks) {
                if (task.getRunnable() != runnable) continue;
                this.tasks.remove(task);
                return task;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTask(TimerTask task) {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            this.tasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTasks() {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            if (this.tasks.size() > 0) {
                this.initializeTimer();
                for (TimerExecTask task : this.tasks) {
                    this.timer.schedule((TimerTask)task, new Date(task.scheduledExecutionTime()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        Object object = this.display.getDeviceLock();
        synchronized (object) {
            stream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        stream.registerValidation(new PostDeserializationValidation(), 0);
    }

    private class PostDeserializationValidation
    implements ObjectInputValidation {
        private PostDeserializationValidation() {
        }

        @Override
        public void validateObject() throws InvalidObjectException {
            UISession uiSession = this.getUISession();
            PostDeserialization.addProcessor(uiSession, new Runnable(){

                @Override
                public void run() {
                    TimerExecScheduler.this.rescheduleTasks();
                }
            });
        }

        private UISession getUISession() {
            IDisplayAdapter adapter = TimerExecScheduler.this.display.getAdapter(IDisplayAdapter.class);
            return adapter.getUISession();
        }
    }
}

