/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

class ConfigurationAdminImpl
implements ConfigurationAdmin {
    private final ConfigurationAdminFactory configurationAdminFactory;
    private final String bundleLocation;
    private final ConfigurationStore configurationStore;

    public ConfigurationAdminImpl(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, Bundle bundle) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
        this.bundleLocation = ConfigurationAdminImpl.getLocation(bundle);
    }

    public Configuration createFactoryConfiguration(String factoryPid) {
        return this.internalGetConfiguration(factoryPid, this.bundleLocation, true, true, null);
    }

    public Configuration createFactoryConfiguration(String factoryPid, String location) {
        return this.internalGetConfiguration(factoryPid, location, true, false, null);
    }

    public Configuration getConfiguration(String pid) {
        return this.internalGetConfiguration(pid, this.bundleLocation, false, true, null);
    }

    public Configuration getConfiguration(String pid, String location) {
        return this.internalGetConfiguration(pid, location, false, false, null);
    }

    public Configuration getFactoryConfiguration(String factoryPid, String name) {
        return this.internalGetConfiguration(factoryPid, this.bundleLocation, true, true, name);
    }

    public Configuration getFactoryConfiguration(String factoryPid, String name, String location) {
        return this.internalGetConfiguration(factoryPid, location, true, false, name);
    }

    private Configuration internalGetConfiguration(String pid, String location, boolean factory, boolean bind, String name) {
        this.checkPID(pid);
        this.configurationAdminFactory.checkConfigurePermission(location, this.bundleLocation);
        ConfigurationImpl config = factory ? this.configurationStore.getFactoryConfiguration(pid, location, bind, name) : this.configurationStore.getConfiguration(pid, location, bind);
        String configLocation = config.getLocation();
        if (bind) {
            if (configLocation != null) {
                this.configurationAdminFactory.checkConfigurePermission(configLocation, this.bundleLocation);
            } else {
                config.bind(this.bundleLocation);
            }
        } else {
            this.configurationAdminFactory.checkConfigurePermission(configLocation, this.bundleLocation);
        }
        return config;
    }

    public Configuration[] listConfigurations(String filterString) throws InvalidSyntaxException {
        ConfigurationImpl[] configs;
        if (filterString == null) {
            filterString = "(service.pid=*)";
        }
        if ((configs = this.configurationStore.listConfigurations(FrameworkUtil.createFilter((String)filterString))) == null) {
            return null;
        }
        ArrayList<ConfigurationImpl> result = new ArrayList<ConfigurationImpl>(configs.length);
        SecurityManager sm = System.getSecurityManager();
        int i = 0;
        while (i < configs.length) {
            try {
                if (sm != null) {
                    this.configurationAdminFactory.checkConfigurePermission(configs[i].getLocation(), this.bundleLocation);
                }
                result.add(configs[i]);
            }
            catch (SecurityException securityException) {}
            ++i;
        }
        return result.size() == 0 ? null : result.toArray(new Configuration[result.size()]);
    }

    private void checkPID(String pid) {
        if (pid == null) {
            throw new IllegalArgumentException("PID cannot be null");
        }
    }

    static String getLocation(final Bundle bundle) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return bundle.getLocation();
            }
        });
    }
}

