/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.listkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IListAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.listkit.ListOperationHandler;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;

public class ListLCA
extends WidgetLCA<List> {
    public static final ListLCA INSTANCE = new ListLCA();
    private static final String TYPE = "rwt.widgets.List";
    private static final String[] ALLOWED_STYLES = new String[]{"SINGLE", "MULTI", "BORDER"};
    private static final String PROP_ITEMS = "items";
    private static final String PROP_SELECTION_INDICES = "selectionIndices";
    private static final String PROP_TOP_INDEX = "topIndex";
    private static final String PROP_FOCUS_INDEX = "focusIndex";
    private static final String PROP_ITEM_DIMENSIONS = "itemDimensions";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final int[] DEFAUT_SELECTION_INDICES = new int[0];
    private static final int DEFAULT_TOP_INDEX = 0;
    private static final int DEFAULT_FOCUS_INDEX = -1;
    private static final Point DEFAULT_ITEM_DIMENSIONS = new Point(0, 0);

    @Override
    public void preserveValues(List list) {
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_ITEMS, list.getItems());
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_SELECTION_INDICES, list.getSelectionIndices());
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_TOP_INDEX, list.getTopIndex());
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_FOCUS_INDEX, list.getFocusIndex());
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_ITEM_DIMENSIONS, ListLCA.getItemDimensions(list));
    }

    @Override
    public void renderInitialization(List list) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(list, TYPE);
        remoteObject.setHandler(new ListOperationHandler(list));
        remoteObject.set("parent", WidgetUtil.getId(list.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(list, ALLOWED_STYLES)));
        remoteObject.set(PROP_MARKUP_ENABLED, MarkupUtil.isMarkupEnabledFor(list));
    }

    @Override
    public void renderChanges(List list) throws IOException {
        ControlLCAUtil.renderChanges(list);
        WidgetLCAUtil.renderCustomVariant(list);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_ITEMS, list.getItems(), DEFAUT_ITEMS);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_SELECTION_INDICES, list.getSelectionIndices(), DEFAUT_SELECTION_INDICES);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_TOP_INDEX, list.getTopIndex(), 0);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_FOCUS_INDEX, list.getFocusIndex(), -1);
        WidgetLCAUtil.renderListenSelection(list);
        WidgetLCAUtil.renderListenDefaultSelection(list);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_ITEM_DIMENSIONS, ListLCA.getItemDimensions(list), DEFAULT_ITEM_DIMENSIONS);
    }

    private static Point getItemDimensions(List list) {
        return ListLCA.getAdapter(list).getItemDimensions();
    }

    private static IListAdapter getAdapter(List list) {
        return list.getAdapter(IListAdapter.class);
    }

    private ListLCA() {
    }
}

