/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.internal.Person;
import org.eclipse.rap.examples.pages.internal.Persons;
import org.eclipse.rap.examples.pages.internal.PersonsTemplate;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.UrlLauncher;
import org.eclipse.rap.rwt.widgets.DialogUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class RowTemplateExample
implements IExamplePage {
    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        parent.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)true, (boolean)true, (boolean)true));
        parent.setLayoutData((Object)ExampleUtil.createFillData());
        this.createTable(parent);
    }

    private void createTable(Composite comp) {
        TableViewer tableViewer = new TableViewer(comp, 67584);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.configColumnViewer(tableViewer);
        Table table = tableViewer.getTable();
        table.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionListener(comp));
        table.setData("org.eclipse.rap.rwt.customItemHeight", (Object)56);
        GridData tableLayoutData = ExampleUtil.createFillData();
        tableLayoutData.verticalIndent = 10;
        table.setLayoutData((Object)tableLayoutData);
        table.setData("org.eclipse.rap.rwt.rowTemplate", (Object)new PersonsTemplate());
    }

    private void configColumnViewer(TableViewer viewer) {
        this.addFirstNameColumn((ColumnViewer)viewer);
        this.addLastNameColumn((ColumnViewer)viewer);
        this.addPhoneColumn((ColumnViewer)viewer);
        this.addMailColumn((ColumnViewer)viewer);
        viewer.setInput((Object)Persons.get(viewer.getControl().getDisplay()));
    }

    private void addFirstNameColumn(ColumnViewer viewer) {
        ViewerColumn firstNameColumn = this.createViewerColumn(viewer, "First Name", 200);
        firstNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Person p = (Person)element;
                return p.getFirstName();
            }

            public Image getImage(Object element) {
                Person p = (Person)element;
                return p.getImage();
            }
        });
    }

    private void addLastNameColumn(ColumnViewer viewer) {
        ViewerColumn lastNameColumn = this.createViewerColumn(viewer, "Last Name", 200);
        lastNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Person p = (Person)element;
                return p.getLastName();
            }
        });
    }

    private void addPhoneColumn(ColumnViewer viewer) {
        ViewerColumn pohoneColumn = this.createViewerColumn(viewer, "Phone", 130);
        pohoneColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Person p = (Person)element;
                return p.getPhone();
            }
        });
    }

    private void addMailColumn(ColumnViewer viewer) {
        ViewerColumn pohoneColumn = this.createViewerColumn(viewer, "E-Mail", 180);
        pohoneColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Person p = (Person)element;
                return p.getMail();
            }
        });
    }

    private ViewerColumn createViewerColumn(ColumnViewer viewer, String name, int width) {
        TableViewerColumn viewerColumn = null;
        if (viewer instanceof TableViewer) {
            TableViewer tableViewer = (TableViewer)viewer;
            TableViewerColumn tableColumn = new TableViewerColumn(tableViewer, 0);
            tableColumn.getColumn().setWidth(width);
            tableColumn.getColumn().setText(name);
            viewerColumn = tableColumn;
        } else if (viewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            TreeViewerColumn treeColumn = new TreeViewerColumn(treeViewer, 0);
            treeColumn.getColumn().setWidth(width);
            treeColumn.getColumn().setText(name);
            viewerColumn = treeColumn;
        }
        return viewerColumn;
    }

    private final class SelectionListener
    extends SelectionAdapter {
        private final Composite parent;

        private SelectionListener(Composite parent) {
            this.parent = parent;
        }

        public void widgetSelected(SelectionEvent e) {
            if ("phone".equals(e.text)) {
                TableItem item = (TableItem)e.item;
                this.alert("Dialing...", "Calling " + item.getText(2) + "!");
            } else if ("mail".equals(e.text)) {
                String mail = ((TableItem)e.item).getText(3);
                String firstName = ((TableItem)e.item).getText(0);
                UrlLauncher launcher = (UrlLauncher)RWT.getClient().getService(UrlLauncher.class);
                if (launcher != null) {
                    launcher.openURL("mailto:" + mail + "?subject=RAP%20Rocks!&body=Hello%20" + firstName);
                } else {
                    this.alert("Now mailing to...", mail);
                }
            } else if ("arrow".equals(e.text)) {
                TableItem item = (TableItem)e.item;
                String firstName = item.getText(0);
                this.alert("Nothing here", "Lets edit " + firstName + "!");
            }
        }

        private void alert(String title, String message) {
            MessageBox messageBox = new MessageBox(this.parent.getShell(), 2);
            messageBox.setText(title);
            messageBox.setMessage(message);
            DialogUtil.open((Dialog)messageBox, null);
        }
    }
}

