/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.context.ContextPathCustomizer;
import org.eclipse.equinox.http.servlet.dto.ExtendedFailedServletDTO;
import org.eclipse.equinox.http.servlet.internal.HttpServiceObjectRegistration;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.context.HttpContextHelperFactory;
import org.eclipse.equinox.http.servlet.internal.context.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.equinox.http.servlet.internal.error.IllegalContextNameException;
import org.eclipse.equinox.http.servlet.internal.error.IllegalContextPathException;
import org.eclipse.equinox.http.servlet.internal.error.PatternInUseException;
import org.eclipse.equinox.http.servlet.internal.error.RegisteredFilterException;
import org.eclipse.equinox.http.servlet.internal.error.ServletAlreadyRegisteredException;
import org.eclipse.equinox.http.servlet.internal.servlet.Match;
import org.eclipse.equinox.http.servlet.internal.util.DTOUtil;
import org.eclipse.equinox.http.servlet.internal.util.Path;
import org.eclipse.equinox.http.servlet.internal.util.ServiceProperties;
import org.eclipse.equinox.http.servlet.internal.util.StringPlus;
import org.eclipse.equinox.http.servlet.internal.util.Throw;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.ErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.FilterDTO;
import org.osgi.service.http.runtime.dto.ListenerDTO;
import org.osgi.service.http.runtime.dto.RequestInfoDTO;
import org.osgi.service.http.runtime.dto.ResourceDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletDTO;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HttpServiceRuntimeImpl
implements HttpServiceRuntime,
ServiceTrackerCustomizer<ServletContextHelper, AtomicReference<ContextController>> {
    private Map<String, Object> attributes;
    private final String targetFilter;
    private final ServiceRegistration<ServletContextHelper> defaultContextReg;
    private ServletContext parentServletContext;
    private BundleContext trackingContext;
    private BundleContext consumingContext;
    private final org.osgi.framework.Filter servletServiceFilter;
    private final org.osgi.framework.Filter resourceServiceFilter;
    private final org.osgi.framework.Filter filterServiceFilter;
    private final org.osgi.framework.Filter listenerServiceFilter;
    private Map<HttpContext, HttpContextHelperFactory> httpContextHelperFactories = Collections.synchronizedMap(new HashMap());
    private Map<Object, HttpServiceObjectRegistration> legacyMappings = Collections.synchronizedMap(new HashMap());
    private Map<Bundle, Set<HttpServiceObjectRegistration>> bundleRegistrations = new HashMap<Bundle, Set<HttpServiceObjectRegistration>>();
    private Map<Bundle, Map<String, String>> bundleAliasCustomizations = new HashMap<Bundle, Map<String, String>>();
    private ConcurrentMap<ServiceReference<ServletContextHelper>, ContextController> controllerMap = new ConcurrentHashMap<ServiceReference<ServletContextHelper>, ContextController>();
    private final ConcurrentMap<ServiceReference<Filter>, FailedFilterDTO> failedFilterDTOs = new ConcurrentHashMap<ServiceReference<Filter>, FailedFilterDTO>();
    private final ConcurrentMap<ServiceReference<EventListener>, FailedListenerDTO> failedListenerDTOs = new ConcurrentHashMap<ServiceReference<EventListener>, FailedListenerDTO>();
    private final ConcurrentMap<ServiceReference<Object>, FailedResourceDTO> failedResourceDTOs = new ConcurrentHashMap<ServiceReference<Object>, FailedResourceDTO>();
    private final ConcurrentMap<ServiceReference<ServletContextHelper>, FailedServletContextDTO> failedServletContextDTOs = new ConcurrentHashMap<ServiceReference<ServletContextHelper>, FailedServletContextDTO>();
    private final ConcurrentMap<ServiceReference<Servlet>, ExtendedFailedServletDTO> failedServletDTOs = new ConcurrentHashMap<ServiceReference<Servlet>, ExtendedFailedServletDTO>();
    private AtomicLong legacyIdGenerator = new AtomicLong(0L);
    private Set<Object> registeredObjects = Collections.newSetFromMap(new ConcurrentHashMap());
    private ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker;
    private ServiceTracker<ContextPathCustomizer, ContextPathCustomizer> contextPathAdaptorTracker;
    private ContextPathCustomizerHolder contextPathCustomizerHolder;

    public HttpServiceRuntimeImpl(BundleContext trackingContext, BundleContext consumingContext, ServletContext parentServletContext, Map<String, Object> attributes) {
        this.trackingContext = trackingContext;
        this.consumingContext = consumingContext;
        this.servletServiceFilter = HttpServiceRuntimeImpl.createServletFilter(consumingContext);
        this.resourceServiceFilter = HttpServiceRuntimeImpl.createResourceFilter(consumingContext);
        this.filterServiceFilter = HttpServiceRuntimeImpl.createFilterFilter(consumingContext);
        this.listenerServiceFilter = HttpServiceRuntimeImpl.createListenerFilter(consumingContext, parentServletContext);
        this.parentServletContext = parentServletContext;
        this.attributes = attributes;
        this.targetFilter = "(equinox.http.id=" + attributes.get("equinox.http.id") + ")";
        this.contextServiceTracker = new ServiceTracker(trackingContext, ServletContextHelper.class, (ServiceTrackerCustomizer)this);
        this.contextPathCustomizerHolder = new ContextPathCustomizerHolder(consumingContext, this.contextServiceTracker);
        this.contextPathAdaptorTracker = new ServiceTracker(consumingContext, ContextPathCustomizer.class, (ServiceTrackerCustomizer)this.contextPathCustomizerHolder);
        this.contextPathAdaptorTracker.open();
        this.contextServiceTracker.open();
        Hashtable<String, Object> defaultContextProps = new Hashtable<String, Object>();
        defaultContextProps.put("osgi.http.whiteboard.context.name", "default");
        defaultContextProps.put("service.ranking", Integer.MIN_VALUE);
        defaultContextProps.put("osgi.http.whiteboard.context.path", "/");
        defaultContextProps.put("osgi.http.whiteboard.target", this.targetFilter);
        this.defaultContextReg = consumingContext.registerService(ServletContextHelper.class, (ServiceFactory)new DefaultServletContextHelperFactory(), defaultContextProps);
    }

    public synchronized AtomicReference<ContextController> addingService(ServiceReference<ServletContextHelper> serviceReference) {
        AtomicReference<ContextController> result = new AtomicReference<ContextController>();
        if (!this.matches(serviceReference)) {
            return result;
        }
        String contextName = (String)serviceReference.getProperty("osgi.http.whiteboard.context.name");
        String contextPath = (String)serviceReference.getProperty("osgi.http.whiteboard.context.path");
        try {
            if (contextName == null) {
                throw new IllegalContextNameException("osgi.http.whiteboard.context.name is null. Ignoring!", 6);
            }
            if (contextPath == null) {
                throw new IllegalContextPathException("osgi.http.whiteboard.context.path is null. Ignoring!", 6);
            }
            contextPath = this.adaptContextPath(contextPath, serviceReference);
            ContextController contextController = new ContextController(this.trackingContext, this.consumingContext, serviceReference, new ProxyContext(this.parentServletContext), this, contextName, contextPath);
            this.controllerMap.put(serviceReference, contextController);
            result.set(contextController);
        }
        catch (HttpWhiteboardFailureException hwfe) {
            this.parentServletContext.log(hwfe.getMessage(), (Throwable)hwfe);
            this.recordFailedServletContextDTO(serviceReference, contextName, contextPath, hwfe.getFailureReason());
        }
        catch (Exception e) {
            this.parentServletContext.log(e.getMessage(), (Throwable)e);
            this.recordFailedServletContextDTO(serviceReference, contextName, contextPath, 4);
        }
        return result;
    }

    private String adaptContextPath(String contextPath, ServiceReference<ServletContextHelper> helper) {
        String contextPrefix;
        ContextPathCustomizer pathAdaptor = this.contextPathCustomizerHolder.getHighestRanked();
        if (pathAdaptor != null && (contextPrefix = pathAdaptor.getContextPathPrefix(helper)) != null && !contextPrefix.isEmpty() && !contextPrefix.equals("/")) {
            if (!contextPrefix.startsWith("/")) {
                contextPrefix = "/" + contextPrefix;
            }
            if (contextPath == null || contextPath.equals("/")) {
                contextPath = "";
            }
            return String.valueOf(contextPrefix) + contextPath;
        }
        return contextPath;
    }

    public String getDefaultContextSelectFilter(ServiceReference<?> httpWhiteBoardService) {
        ContextPathCustomizer pathAdaptor = this.contextPathCustomizerHolder.getHighestRanked();
        if (pathAdaptor != null) {
            return pathAdaptor.getDefaultContextSelectFilter(httpWhiteBoardService);
        }
        return null;
    }

    public RequestInfoDTO calculateRequestInfoDTO(String path) {
        RequestInfoDTO requestInfoDTO = new RequestInfoDTO();
        requestInfoDTO.path = path;
        try {
            this.getDispatchTargets(path, requestInfoDTO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return requestInfoDTO;
    }

    public void destroy() {
        this.defaultContextReg.unregister();
        this.contextServiceTracker.close();
        this.contextPathAdaptorTracker.close();
        this.controllerMap.clear();
        this.registeredObjects.clear();
        this.failedFilterDTOs.clear();
        this.failedListenerDTOs.clear();
        this.failedResourceDTOs.clear();
        this.failedServletContextDTOs.clear();
        this.failedServletDTOs.clear();
        this.attributes = null;
        this.trackingContext = null;
        this.consumingContext = null;
        this.legacyIdGenerator = null;
        this.parentServletContext = null;
        this.registeredObjects = null;
        this.contextServiceTracker = null;
        this.contextPathCustomizerHolder = null;
    }

    public DispatchTargets getDispatchTargets(String pathString, RequestInfoDTO requestInfoDTO) {
        Path path = new Path(pathString);
        String queryString = path.getQueryString();
        String requestURI = path.getRequestURI();
        DispatchTargets dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.EXACT, requestInfoDTO);
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, path.getExtension(), queryString, Match.EXTENSION, requestInfoDTO);
        }
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.REGEX, requestInfoDTO);
        }
        if (dispatchTargets == null) {
            dispatchTargets = this.getDispatchTargets(requestURI, null, queryString, Match.DEFAULT_SERVLET, requestInfoDTO);
        }
        return dispatchTargets;
    }

    public Set<Object> getRegisteredObjects() {
        return this.registeredObjects;
    }

    public List<String> getHttpServiceEndpoints() {
        return StringPlus.from(this.attributes.get("osgi.http.endpoint"));
    }

    public RuntimeDTO getRuntimeDTO() {
        RuntimeDTO runtimeDTO = new RuntimeDTO();
        runtimeDTO.serviceDTO = this.getServiceDTO();
        runtimeDTO.failedErrorPageDTOs = null;
        runtimeDTO.failedFilterDTOs = this.getFailedFilterDTOs();
        runtimeDTO.failedListenerDTOs = this.getFailedListenerDTOs();
        runtimeDTO.failedResourceDTOs = this.getFailedResourceDTOs();
        runtimeDTO.failedServletContextDTOs = this.getFailedServletContextDTO();
        runtimeDTO.failedServletDTOs = this.getFailedServletDTOs();
        runtimeDTO.servletContextDTOs = this.getServletContextDTOs();
        return runtimeDTO;
    }

    private ServiceReferenceDTO getServiceDTO() {
        ServiceReferenceDTO[] services;
        ServiceReferenceDTO[] serviceReferenceDTOArray = services = (ServiceReferenceDTO[])this.consumingContext.getBundle().adapt(ServiceReferenceDTO[].class);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            String[] serviceTypes;
            ServiceReferenceDTO serviceDTO = serviceReferenceDTOArray[n2];
            String[] stringArray = serviceTypes = (String[])serviceDTO.properties.get("objectClass");
            int n3 = serviceTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                String type = stringArray[n4];
                if (HttpServiceRuntime.class.getName().equals(type)) {
                    return serviceDTO;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void log(String message, Throwable t) {
        this.parentServletContext.log(message, t);
    }

    public boolean matches(ServiceReference<?> serviceReference) {
        org.osgi.framework.Filter targetFilter;
        String target = (String)serviceReference.getProperty("osgi.http.whiteboard.target");
        if (target == null) {
            return true;
        }
        try {
            targetFilter = FrameworkUtil.createFilter((String)target);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
        return targetFilter.matches(this.attributes);
    }

    public synchronized void modifiedService(ServiceReference<ServletContextHelper> serviceReference, AtomicReference<ContextController> contextController) {
        this.removedService(serviceReference, contextController);
        Object added = this.addingService((ServiceReference)serviceReference);
        contextController.set((ContextController)((AtomicReference)added).get());
    }

    public synchronized void removedService(ServiceReference<ServletContextHelper> serviceReference, AtomicReference<ContextController> contextControllerRef) {
        ContextController contextController = contextControllerRef.get();
        if (contextController != null) {
            contextController.destroy();
        }
        this.controllerMap.remove(serviceReference);
        this.failedServletContextDTOs.remove(serviceReference);
        this.trackingContext.ungetService(serviceReference);
    }

    Collection<ContextController> getContextControllers(String requestURI) {
        int pos = requestURI.lastIndexOf(47);
        while (true) {
            ArrayList<ContextController> contextControllers = new ArrayList<ContextController>();
            for (ContextController contextController : this.controllerMap.values()) {
                if (!contextController.getContextPath().equals(requestURI)) continue;
                contextControllers.add(contextController);
            }
            if (!contextControllers.isEmpty()) {
                return contextControllers;
            }
            if (pos <= -1) break;
            requestURI = requestURI.substring(0, pos);
            pos = requestURI.lastIndexOf(47);
        }
        return null;
    }

    long generateLegacyId() {
        return this.legacyIdGenerator.getAndIncrement();
    }

    public DispatchTargets getDispatchTargets(String requestURI, String extension, String queryString, Match match, RequestInfoDTO requestInfoDTO) {
        Collection<ContextController> contextControllers = this.getContextControllers(requestURI);
        if (contextControllers == null || contextControllers.isEmpty()) {
            return null;
        }
        String contextPath = contextControllers.iterator().next().getContextPath();
        requestURI = requestURI.substring(contextPath.length());
        int pos = requestURI.lastIndexOf(47);
        String servletPath = requestURI;
        String pathInfo = null;
        if (match == Match.DEFAULT_SERVLET) {
            pathInfo = servletPath;
            servletPath = "/";
        }
        while (true) {
            for (ContextController contextController : contextControllers) {
                DispatchTargets dispatchTargets = contextController.getDispatchTargets(null, requestURI, servletPath, pathInfo, extension, queryString, match, requestInfoDTO);
                if (dispatchTargets == null) continue;
                return dispatchTargets;
            }
            if (match == Match.EXACT || pos <= -1) break;
            String newServletPath = requestURI.substring(0, pos);
            pathInfo = requestURI.substring(pos);
            servletPath = newServletPath;
            pos = servletPath.lastIndexOf(47);
        }
        return null;
    }

    private FailedFilterDTO[] getFailedFilterDTOs() {
        Collection ffDTOs = this.failedFilterDTOs.values();
        ArrayList<FailedFilterDTO> copies = new ArrayList<FailedFilterDTO>();
        for (FailedFilterDTO failedFilterDTO : ffDTOs) {
            copies.add(DTOUtil.clone(failedFilterDTO));
        }
        return copies.toArray(new FailedFilterDTO[copies.size()]);
    }

    private FailedListenerDTO[] getFailedListenerDTOs() {
        Collection flDTOs = this.failedListenerDTOs.values();
        ArrayList<FailedListenerDTO> copies = new ArrayList<FailedListenerDTO>();
        for (FailedListenerDTO failedListenerDTO : flDTOs) {
            copies.add(DTOUtil.clone(failedListenerDTO));
        }
        return copies.toArray(new FailedListenerDTO[copies.size()]);
    }

    private FailedResourceDTO[] getFailedResourceDTOs() {
        Collection frDTOs = this.failedResourceDTOs.values();
        ArrayList<FailedResourceDTO> copies = new ArrayList<FailedResourceDTO>();
        for (FailedResourceDTO failedResourceDTO : frDTOs) {
            copies.add(DTOUtil.clone(failedResourceDTO));
        }
        return copies.toArray(new FailedResourceDTO[copies.size()]);
    }

    private FailedServletContextDTO[] getFailedServletContextDTO() {
        Collection fscDTOs = this.failedServletContextDTOs.values();
        ArrayList<FailedServletContextDTO> copies = new ArrayList<FailedServletContextDTO>();
        for (FailedServletContextDTO failedServletContextDTO : fscDTOs) {
            copies.add(DTOUtil.clone(failedServletContextDTO));
        }
        return copies.toArray(new FailedServletContextDTO[copies.size()]);
    }

    private FailedServletDTO[] getFailedServletDTOs() {
        Collection fsDTOs = this.failedServletDTOs.values();
        ArrayList<ExtendedFailedServletDTO> copies = new ArrayList<ExtendedFailedServletDTO>();
        for (ExtendedFailedServletDTO failedServletDTO : fsDTOs) {
            copies.add(DTOUtil.clone(failedServletDTO));
        }
        return copies.toArray(new FailedServletDTO[copies.size()]);
    }

    private ServletContextDTO[] getServletContextDTOs() {
        ArrayList<ServletContextDTO> servletContextDTOs = new ArrayList<ServletContextDTO>();
        for (ContextController contextController : this.controllerMap.values()) {
            servletContextDTOs.add(contextController.getServletContextDTO());
        }
        return servletContextDTOs.toArray(new ServletContextDTO[servletContextDTOs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceFilter(Bundle bundle, String alias, Filter filter, Dictionary<String, String> initparams, HttpContext httpContext) throws ServletException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        ContextController.checkPattern(alias);
        if (!(alias.endsWith("/*") || alias.startsWith("*.") || alias.contains("/*."))) {
            alias = alias.endsWith("/") ? String.valueOf(alias) + '*' : String.valueOf(alias) + "/*";
        }
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            if (this.getRegisteredObjects().contains(filter)) {
                throw new RegisteredFilterException(filter);
            }
            HttpServiceObjectRegistration existing = this.legacyMappings.get(filter);
            if (existing != null) {
                throw new RegisteredFilterException(filter);
            }
            String filterName = filter.getClass().getName();
            if (initparams != null && initparams.get("filter-name") != null) {
                filterName = initparams.get("filter-name");
            }
            HttpContextHelperFactory factory = this.getOrRegisterHttpContextHelperFactory(bundle, httpContext);
            HttpServiceObjectRegistration objectRegistration = null;
            ServiceRegistration registration = null;
            try {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", alias);
                ((Dictionary)props).put("osgi.http.whiteboard.filter.name", filterName);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(equinox.legacy.context.helper=true)");
                ((Dictionary)props).put("equinox.context.select", factory.getFilter());
                ((Dictionary)props).put("equinox.legacy.tccl", Thread.currentThread().getContextClassLoader());
                ((Dictionary)props).put("service.ranking", HttpServiceRuntimeImpl.findFilterPriority(initparams));
                this.fillInitParams(props, initparams, "filter.init.");
                LegacyFilterFactory filterFactory = new LegacyFilterFactory(filter);
                registration = bundle.getBundleContext().registerService(Filter.class, (ServiceFactory)filterFactory, props);
                filterFactory.checkForError();
                objectRegistration = new HttpServiceObjectRegistration(filter, registration, factory, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(factory);
                    if (registration != null) {
                        registration.unregister();
                    }
                }
            }
        }
    }

    private void fillInitParams(Dictionary<String, Object> props, Dictionary<String, String> initparams, String prefix) {
        if (initparams != null) {
            Enumeration<String> eKeys = initparams.keys();
            while (eKeys.hasMoreElements()) {
                String key = eKeys.nextElement();
                String value = initparams.get(key);
                if (value == null) continue;
                props.put(String.valueOf(prefix) + key, value);
            }
        }
    }

    private static int findFilterPriority(Dictionary<String, String> initparams) {
        if (initparams == null) {
            return 0;
        }
        String filterPriority = initparams.get("filter-priority");
        if (filterPriority == null) {
            return 0;
        }
        try {
            int result = Integer.parseInt(filterPriority);
            if (result >= -1000 && result <= 1000) {
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException("filter-priority must be an integer between -1000 and 1000 but was: " + filterPriority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceResources(Bundle bundle, String alias, String name, HttpContext httpContext) throws NamespaceException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        String pattern = alias;
        if (pattern.startsWith("/*.")) {
            pattern = pattern.substring(1);
        } else if (!(pattern.contains("*.") || pattern.endsWith("/*") || pattern.endsWith("/"))) {
            pattern = String.valueOf(pattern) + "/*";
        }
        ContextController.checkPattern(alias);
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            HttpServiceObjectRegistration objectRegistration = null;
            HttpContextHelperFactory factory = this.getOrRegisterHttpContextHelperFactory(bundle, httpContext);
            try {
                String fullAlias = this.getFullAlias(alias, factory);
                HttpServiceObjectRegistration existing = this.legacyMappings.get(fullAlias);
                if (existing != null) {
                    throw new PatternInUseException(alias);
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.resource.pattern", pattern);
                ((Dictionary)props).put("osgi.http.whiteboard.resource.prefix", name);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", factory.getFilter());
                ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
                ((Dictionary)props).put("equinox.legacy.tccl", Thread.currentThread().getContextClassLoader());
                ServiceRegistration registration = bundle.getBundleContext().registerService(String.class, (Object)"resource", props);
                objectRegistration = new HttpServiceObjectRegistration(fullAlias, registration, factory, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                Map<String, String> aliasCustomizations = this.bundleAliasCustomizations.get(bundle);
                if (aliasCustomizations == null) {
                    aliasCustomizations = new HashMap<String, String>();
                    this.bundleAliasCustomizations.put(bundle, aliasCustomizations);
                }
                aliasCustomizations.put(alias, fullAlias);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(factory);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHttpServiceServlet(Bundle bundle, String alias, Servlet servlet, Dictionary<String, String> initparams, HttpContext httpContext) throws NamespaceException, ServletException {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        ContextController.checkPattern((String)alias);
        String[] pattern = alias;
        if (!(alias.endsWith("/*") || alias.startsWith("*.") || alias.contains("/*."))) {
            pattern = alias.endsWith("/") ? new String[]{alias, String.valueOf(alias) + '*'} : new String[]{alias, String.valueOf(alias) + "/*"};
        }
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            LegacyServlet legacyServlet = new LegacyServlet(servlet);
            if (this.getRegisteredObjects().contains(legacyServlet)) {
                throw new ServletAlreadyRegisteredException(servlet);
            }
            HttpServiceObjectRegistration objectRegistration = null;
            ServiceRegistration registration = null;
            HttpContextHelperFactory factory = this.getOrRegisterHttpContextHelperFactory(bundle, httpContext);
            try {
                String fullAlias = this.getFullAlias((String)alias, factory);
                HttpServiceObjectRegistration existing = this.legacyMappings.get(fullAlias);
                if (existing != null) {
                    throw new PatternInUseException((String)alias);
                }
                String servletName = servlet.getClass().getName();
                if (initparams != null && initparams.get("servlet-name") != null) {
                    servletName = initparams.get("servlet-name");
                }
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", pattern);
                ((Dictionary)props).put("osgi.http.whiteboard.servlet.name", servletName);
                ((Dictionary)props).put("osgi.http.whiteboard.context.select", factory.getFilter());
                ((Dictionary)props).put("service.ranking", Integer.MAX_VALUE);
                ((Dictionary)props).put("equinox.legacy.tccl", Thread.currentThread().getContextClassLoader());
                this.fillInitParams(props, initparams, "servlet.init.");
                registration = bundle.getBundleContext().registerService(Servlet.class, (Object)legacyServlet, props);
                legacyServlet.checkForError();
                objectRegistration = new HttpServiceObjectRegistration(fullAlias, registration, factory, bundle);
                Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
                if (objectRegistrations == null) {
                    objectRegistrations = new HashSet<HttpServiceObjectRegistration>();
                    this.bundleRegistrations.put(bundle, objectRegistrations);
                }
                objectRegistrations.add(objectRegistration);
                Map<String, String> aliasCustomizations = this.bundleAliasCustomizations.get(bundle);
                if (aliasCustomizations == null) {
                    aliasCustomizations = new HashMap<String, String>();
                    this.bundleAliasCustomizations.put(bundle, aliasCustomizations);
                }
                aliasCustomizations.put((String)alias, fullAlias);
                this.legacyMappings.put(objectRegistration.serviceKey, objectRegistration);
            }
            finally {
                if (objectRegistration == null || !this.legacyMappings.containsKey(objectRegistration.serviceKey)) {
                    this.decrementFactoryUseCount(factory);
                    if (registration != null) {
                        registration.unregister();
                    }
                }
            }
        }
    }

    private String getFullAlias(String alias, HttpContextHelperFactory factory) {
        ContextController controller;
        AtomicReference controllerRef = (AtomicReference)this.contextServiceTracker.getService(factory.getServiceReference());
        if (controllerRef != null && (controller = (ContextController)controllerRef.get()) != null) {
            return String.valueOf(controller.getContextPath()) + alias;
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceAlias(Bundle bundle, String alias) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            String aliasCustomization;
            Map<String, String> aliasCustomizations = this.bundleAliasCustomizations.get(bundle);
            String string = aliasCustomization = aliasCustomizations == null ? null : aliasCustomizations.remove(alias);
            if (aliasCustomization == null) {
                throw new IllegalArgumentException("The bundle did not register the alias: " + alias);
            }
            HttpServiceObjectRegistration objectRegistration = this.legacyMappings.get(aliasCustomization);
            if (objectRegistration == null) {
                throw new IllegalArgumentException("No registration found for alias: " + alias);
            }
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
            if (objectRegistrations == null || !objectRegistrations.remove(objectRegistration)) {
                throw new IllegalArgumentException("The bundle did not register the alias: " + alias);
            }
            try {
                objectRegistration.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
            this.decrementFactoryUseCount(objectRegistration.factory);
            this.legacyMappings.remove(aliasCustomization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceFilter(Bundle bundle, Filter filter) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            HttpServiceObjectRegistration objectRegistration = this.legacyMappings.get(filter);
            if (objectRegistration == null) {
                throw new IllegalArgumentException("No registration found for filter: " + filter);
            }
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.get(bundle);
            if (objectRegistrations == null || !objectRegistrations.remove(objectRegistration)) {
                throw new IllegalArgumentException("The bundle did not register the filter: " + filter);
            }
            try {
                objectRegistration.registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
            this.decrementFactoryUseCount(objectRegistration.factory);
            this.legacyMappings.remove(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHttpServiceObjects(Bundle bundle) {
        Map<Object, HttpServiceObjectRegistration> map = this.legacyMappings;
        synchronized (map) {
            this.bundleAliasCustomizations.remove(bundle);
            Set<HttpServiceObjectRegistration> objectRegistrations = this.bundleRegistrations.remove(bundle);
            if (objectRegistrations != null) {
                for (HttpServiceObjectRegistration objectRegistration : objectRegistrations) {
                    try {
                        objectRegistration.registration.unregister();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    this.decrementFactoryUseCount(objectRegistration.factory);
                    this.legacyMappings.remove(objectRegistration.serviceKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpContextHelperFactory getOrRegisterHttpContextHelperFactory(Bundle initiatingBundle, HttpContext httpContext) {
        if (httpContext == null) {
            throw new NullPointerException("A null HttpContext is not allowed.");
        }
        Map<HttpContext, HttpContextHelperFactory> map = this.httpContextHelperFactories;
        synchronized (map) {
            HttpContextHelperFactory factory = this.httpContextHelperFactories.get(httpContext);
            if (factory == null) {
                factory = new HttpContextHelperFactory(httpContext);
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("osgi.http.whiteboard.context.name", String.valueOf(httpContext.getClass().getName().replaceAll("[^a-zA-Z_0-9\\-]", "_")) + "-" + this.generateLegacyId());
                ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/");
                ((Dictionary)props).put("osgi.http.whiteboard.target", this.targetFilter);
                ((Dictionary)props).put("equinox.legacy.context.helper", Boolean.TRUE);
                ((Dictionary)props).put("equinox.legacy.http.context.initiating.id", initiatingBundle.getBundleId());
                factory.setRegistration((ServiceRegistration<ServletContextHelper>)this.consumingContext.registerService(ServletContextHelper.class, (ServiceFactory)factory, props));
                this.httpContextHelperFactories.put(httpContext, factory);
            }
            factory.incrementUseCount();
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementFactoryUseCount(HttpContextHelperFactory factory) {
        Map<HttpContext, HttpContextHelperFactory> map = this.httpContextHelperFactories;
        synchronized (map) {
            if (factory.decrementUseCount() == 0L) {
                this.httpContextHelperFactories.remove(factory.getHttpContext());
            }
        }
    }

    private static org.osgi.framework.Filter createResourceFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(");
        sb.append("osgi.http.whiteboard.resource.prefix");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.resource.pattern");
        sb.append("=*))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static org.osgi.framework.Filter createServletFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Servlet.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.servlet.errorPage");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.servlet.name");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.servlet.pattern");
        sb.append("=*)))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static org.osgi.framework.Filter createFilterFilter(BundleContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectClass=");
        sb.append(Filter.class.getName());
        sb.append(")(|(");
        sb.append("osgi.http.whiteboard.filter.pattern");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.regex");
        sb.append("=*)(");
        sb.append("osgi.http.whiteboard.filter.servlet");
        sb.append("=*)))");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    private static org.osgi.framework.Filter createListenerFilter(BundleContext context, ServletContext servletContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("(&");
        sb.append("(").append("osgi.http.whiteboard.listener").append("=*)");
        sb.append("(|");
        sb.append("(objectClass=").append(ServletContextListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletContextAttributeListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletRequestListener.class.getName()).append(")");
        sb.append("(objectClass=").append(ServletRequestAttributeListener.class.getName()).append(")");
        sb.append("(objectClass=").append(HttpSessionListener.class.getName()).append(")");
        sb.append("(objectClass=").append(HttpSessionAttributeListener.class.getName()).append(")");
        if (servletContext.getMajorVersion() >= 3 && servletContext.getMinorVersion() > 0) {
            sb.append("(objectClass=").append(HttpSessionIdListener.class.getName()).append(")");
        }
        sb.append(")");
        sb.append(")");
        try {
            return context.createFilter(sb.toString());
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public org.osgi.framework.Filter getListenerFilter() {
        return this.listenerServiceFilter;
    }

    public org.osgi.framework.Filter getFilterFilter() {
        return this.filterServiceFilter;
    }

    public org.osgi.framework.Filter getServletFilter() {
        return this.servletServiceFilter;
    }

    public org.osgi.framework.Filter getResourceFilter() {
        return this.resourceServiceFilter;
    }

    public void recordFailedFilterDTO(ServiceReference<Filter> serviceReference, FailedFilterDTO failedFilterDTO) {
        if (this.failedFilterDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedFilterDTOs.put(serviceReference, failedFilterDTO);
    }

    public void recordFailedListenerDTO(ServiceReference<EventListener> serviceReference, FailedListenerDTO failedListenerDTO) {
        if (this.failedListenerDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedListenerDTOs.put(serviceReference, failedListenerDTO);
    }

    public void recordFailedResourceDTO(ServiceReference<Object> serviceReference, FailedResourceDTO failedResourceDTO) {
        if (this.failedResourceDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedResourceDTOs.put(serviceReference, failedResourceDTO);
    }

    private void recordFailedServletContextDTO(ServiceReference<ServletContextHelper> serviceReference, String contextName, String contextPath, int failureReason) {
        FailedServletContextDTO failedServletContextDTO = new FailedServletContextDTO();
        failedServletContextDTO.attributes = Collections.emptyMap();
        failedServletContextDTO.contextPath = contextPath;
        failedServletContextDTO.errorPageDTOs = new ErrorPageDTO[0];
        failedServletContextDTO.failureReason = failureReason;
        failedServletContextDTO.filterDTOs = new FilterDTO[0];
        failedServletContextDTO.initParams = ServiceProperties.parseInitParams(serviceReference, "context.init.");
        failedServletContextDTO.listenerDTOs = new ListenerDTO[0];
        failedServletContextDTO.name = contextName;
        failedServletContextDTO.resourceDTOs = new ResourceDTO[0];
        failedServletContextDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedServletContextDTO.servletDTOs = new ServletDTO[0];
        this.failedServletContextDTOs.put(serviceReference, failedServletContextDTO);
    }

    public void recordFailedServletDTO(ServiceReference<Servlet> serviceReference, ExtendedFailedServletDTO failedServletDTO) {
        if (this.failedServletDTOs.containsKey(serviceReference)) {
            return;
        }
        this.failedServletDTOs.put(serviceReference, failedServletDTO);
    }

    public void removeFailedFilterDTO(ServiceReference<Filter> serviceReference) {
        this.failedFilterDTOs.remove(serviceReference);
    }

    public void removeFailedListenerDTO(ServiceReference<EventListener> serviceReference) {
        this.failedListenerDTOs.remove(serviceReference);
    }

    public void removeFailedResourceDTO(ServiceReference<Object> serviceReference) {
        this.failedResourceDTOs.remove(serviceReference);
    }

    public void removeFailedServletDTOs(ServiceReference<Servlet> serviceReference) {
        this.failedServletDTOs.remove(serviceReference);
    }

    public void fireSessionIdChanged(String oldSessionId) {
        for (ContextController contextController : this.controllerMap.values()) {
            contextController.fireSessionIdChanged(oldSessionId);
        }
    }

    static class ContextPathCustomizerHolder
    implements ServiceTrackerCustomizer<ContextPathCustomizer, ContextPathCustomizer> {
        private final BundleContext context;
        private final ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker;
        private final NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> pathCustomizers = new TreeMap(Collections.reverseOrder());

        public ContextPathCustomizerHolder(BundleContext context, ServiceTracker<ServletContextHelper, AtomicReference<ContextController>> contextServiceTracker) {
            this.context = context;
            this.contextServiceTracker = contextServiceTracker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ContextPathCustomizer addingService(ServiceReference<ContextPathCustomizer> reference) {
            ContextPathCustomizer service = (ContextPathCustomizer)this.context.getService(reference);
            boolean reset = false;
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                this.pathCustomizers.put(reference, service);
                reset = ((ServiceReference)this.pathCustomizers.firstKey()).equals(reference);
            }
            if (reset) {
                this.contextServiceTracker.close();
                this.contextServiceTracker.open();
            }
            return service;
        }

        public void modifiedService(ServiceReference<ContextPathCustomizer> reference, ContextPathCustomizer service) {
            this.removedService(reference, service);
            this.addingService((ServiceReference)reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ContextPathCustomizer> reference, ContextPathCustomizer service) {
            boolean reset = false;
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                ServiceReference currentFirst = (ServiceReference)this.pathCustomizers.firstKey();
                this.pathCustomizers.remove(reference);
                reset = currentFirst.equals(reference);
            }
            if (reset && this.contextServiceTracker.getTrackingCount() >= 0) {
                this.contextServiceTracker.close();
                this.contextServiceTracker.open();
            }
            this.context.ungetService(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ContextPathCustomizer getHighestRanked() {
            NavigableMap<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> navigableMap = this.pathCustomizers;
            synchronized (navigableMap) {
                Map.Entry<ServiceReference<ContextPathCustomizer>, ContextPathCustomizer> firstEntry = this.pathCustomizers.firstEntry();
                return firstEntry == null ? null : firstEntry.getValue();
            }
        }
    }

    static class DefaultServletContextHelper
    extends ServletContextHelper {
        public DefaultServletContextHelper(Bundle b) {
            super(b);
        }
    }

    static class DefaultServletContextHelperFactory
    implements ServiceFactory<ServletContextHelper> {
        DefaultServletContextHelperFactory() {
        }

        public ServletContextHelper getService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration) {
            return new DefaultServletContextHelper(bundle);
        }

        public void ungetService(Bundle bundle, ServiceRegistration<ServletContextHelper> registration, ServletContextHelper service) {
        }
    }

    public static class LegacyFilterFactory
    extends LegacyServiceObject
    implements PrototypeServiceFactory<Filter> {
        final Filter filter;

        public LegacyFilterFactory(Filter filter) {
            this.filter = filter;
        }

        public Filter getService(Bundle bundle, ServiceRegistration<Filter> registration) {
            return new LegacyFilter();
        }

        public void ungetService(Bundle bundle, ServiceRegistration<Filter> registration, Filter service) {
        }

        class LegacyFilter
        implements Filter {
            LegacyFilter() {
            }

            public void init(FilterConfig filterConfig) throws ServletException {
                try {
                    LegacyFilterFactory.this.filter.init(filterConfig);
                    LegacyFilterFactory.this.error.set(null);
                }
                catch (Exception e) {
                    LegacyFilterFactory.this.error.set(e);
                    Throw.unchecked(e);
                }
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                LegacyFilterFactory.this.filter.doFilter(request, response, chain);
            }

            public void destroy() {
                LegacyFilterFactory.this.filter.destroy();
            }
        }
    }

    static class LegacyServiceObject {
        final AtomicReference<Exception> error = new AtomicReference<ServletException>(new ServletException("The init() method was never called."));

        LegacyServiceObject() {
        }

        public void checkForError() {
            Exception result = this.error.get();
            if (result != null) {
                Throw.unchecked(result);
            }
        }
    }

    static class LegacyServlet
    extends LegacyServiceObject
    implements Servlet {
        final Servlet servlet;

        public LegacyServlet(Servlet servlet) {
            this.servlet = servlet;
        }

        public void init(ServletConfig config) throws ServletException {
            try {
                this.servlet.init(config);
                this.error.set(null);
            }
            catch (Exception e) {
                this.error.set(e);
                Throw.unchecked(e);
            }
        }

        public ServletConfig getServletConfig() {
            return this.servlet.getServletConfig();
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            this.servlet.service(req, res);
        }

        public String getServletInfo() {
            return this.servlet.getServletInfo();
        }

        public void destroy() {
            this.servlet.destroy();
        }

        public int hashCode() {
            return this.servlet.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof LegacyServlet) {
                other = ((LegacyServlet)other).servlet;
            }
            return this.servlet.equals(other);
        }
    }
}

