/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationAdminImpl;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.eclipse.equinox.internal.cm.SerializedTaskQueue;
import org.eclipse.equinox.internal.cm.TargetMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

class ManagedServiceTracker
extends ServiceTracker<ManagedService, ManagedService> {
    final ConfigurationAdminFactory configurationAdminFactory;
    private final ConfigurationStore configurationStore;
    private final TargetMap targets = new TargetMap();
    private final SerializedTaskQueue queue = new SerializedTaskQueue("ManagedService Update Queue");

    public ManagedServiceTracker(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, BundleContext context) {
        super(context, ManagedService.class.getName(), null);
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDeleted(ConfigurationImpl config) {
        config.checkLocked();
        String configLoc = config.getLocation();
        if (configLoc == null) {
            return;
        }
        boolean isMultiple = configLoc.startsWith("?");
        String pid = config.getPid(false);
        List<ServiceReference<ManagedService>> references = this.getManagedServiceReferences(pid);
        for (ServiceReference<ManagedService> ref : references) {
            List<List<String>> qualifiedPidLists;
            if (this.hasMoreSpecificConfigPids(ref, pid)) continue;
            boolean hasLocPermission = this.configurationAdminFactory.checkTargetPermission(configLoc, ref);
            ManagedService service = (ManagedService)this.getService(ref);
            if (!hasLocPermission || service == null || !isMultiple && !ConfigurationAdminImpl.getLocation(ref.getBundle()).equals(configLoc)) continue;
            TargetMap targetMap = this.targets;
            synchronized (targetMap) {
                qualifiedPidLists = this.targets.getQualifiedPids(ref);
            }
            this.updateManagedService(qualifiedPidLists, ref, service);
        }
    }

    void notifyUpdated(ConfigurationImpl config) {
        config.checkLocked();
        String configLoc = config.getLocation();
        boolean isMultiple = configLoc != null && configLoc.startsWith("?");
        String pid = config.getPid();
        List<ServiceReference<ManagedService>> references = this.getManagedServiceReferences(pid);
        for (ServiceReference<ManagedService> ref : references) {
            if (this.hasMoreSpecificConfigPids(ref, pid)) continue;
            boolean hasLocPermission = this.configurationAdminFactory.checkTargetPermission(configLoc, ref);
            ManagedService service = (ManagedService)this.getService(ref);
            if (!hasLocPermission || service == null || !isMultiple && !config.bind(ConfigurationAdminImpl.getLocation(ref.getBundle()))) continue;
            Dictionary<String, Object> properties = this.configurationAdminFactory.modifyConfiguration(ref, config);
            this.asynchUpdated(service, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyUpdateLocation(ConfigurationImpl config, String oldLocation) {
        config.checkLocked();
        String configLoc = config.getLocation();
        if (configLoc == null ? oldLocation == null : configLoc.equals(oldLocation)) {
            return;
        }
        boolean oldIsMultiple = oldLocation != null && oldLocation.startsWith("?");
        boolean newIsMultiple = configLoc != null && configLoc.startsWith("?");
        String pid = config.getPid();
        List<ServiceReference<ManagedService>> references = this.getManagedServiceReferences(pid);
        for (ServiceReference<ManagedService> ref : references) {
            if (this.hasMoreSpecificConfigPids(ref, pid)) continue;
            boolean hasOldPermission = this.configurationAdminFactory.checkTargetPermission(oldLocation, ref);
            boolean hasNewPermission = this.configurationAdminFactory.checkTargetPermission(configLoc, ref);
            ManagedService service = (ManagedService)this.getService(ref);
            if (service == null) continue;
            boolean delete = false;
            boolean update = false;
            String targetLocation = ConfigurationAdminImpl.getLocation(ref.getBundle());
            if (hasOldPermission != hasNewPermission) {
                if (hasOldPermission) {
                    delete = oldIsMultiple || targetLocation.equals(oldLocation);
                } else {
                    update = newIsMultiple || config.bind(targetLocation);
                }
            } else if (targetLocation.equals(oldLocation)) {
                delete = true;
            } else {
                boolean bl = update = newIsMultiple || config.bind(targetLocation);
            }
            if (delete) {
                List<List<String>> qualifiedPidLists;
                TargetMap targetMap = this.targets;
                synchronized (targetMap) {
                    qualifiedPidLists = this.targets.getQualifiedPids(ref);
                }
                this.updateManagedService(qualifiedPidLists, ref, service);
                continue;
            }
            if (!update) continue;
            Dictionary<String, Object> properties = this.configurationAdminFactory.modifyConfiguration(ref, config);
            this.asynchUpdated(service, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMoreSpecificConfigPids(ServiceReference<ManagedService> ref, String pid) {
        List<List<String>> qualifiedPidsLists;
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            qualifiedPidsLists = this.targets.getQualifiedPids(ref);
        }
        block3: for (List<String> qualifiedPids : qualifiedPidsLists) {
            for (String qualifiedPid : qualifiedPids) {
                if (qualifiedPid.length() <= pid.length() || !qualifiedPid.startsWith(pid)) continue block3;
                ConfigurationImpl config = this.configurationStore.findConfiguration(qualifiedPid);
                if (config == null) continue;
                return true;
            }
        }
        return false;
    }

    public ManagedService addingService(ServiceReference<ManagedService> reference) {
        ManagedService service = (ManagedService)this.context.getService(reference);
        if (service == null) {
            return null;
        }
        this.addReference(reference, service);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<ManagedService> reference, ManagedService service) {
        List<String> newPids = TargetMap.getPids(reference.getProperty("service.pid"));
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            List<List<String>> previousPids = this.targets.getQualifiedPids(reference);
            if (newPids.size() == previousPids.size()) {
                boolean foundAll = false;
                for (String newPid : newPids) {
                    foundAll = false;
                    for (List<String> pids : previousPids) {
                        if (!pids.contains(newPid)) continue;
                        foundAll = true;
                        break;
                    }
                    if (!foundAll) break;
                }
                if (foundAll) {
                    return;
                }
            }
        }
        this.untrackManagedService(reference);
        this.addingService(reference);
    }

    public void removedService(ServiceReference<ManagedService> reference, ManagedService service) {
        this.untrackManagedService(reference);
        this.configurationAdminFactory.cancelExecuteCoordinated(service);
        this.context.ungetService(reference);
    }

    private void addReference(ServiceReference<ManagedService> reference, ManagedService service) {
        List<List<String>> qualifiedPidLists = this.trackManagedService(reference);
        this.configurationAdminFactory.executeCoordinated(service, () -> this.updateManagedService(qualifiedPidLists, reference, service));
    }

    private void updateManagedService(List<List<String>> qualifiedPidLists, ServiceReference<ManagedService> reference, ManagedService service) {
        for (List<String> qualifiedPids : qualifiedPidLists) {
            boolean foundConfig = false;
            for (String qualifiedPid : qualifiedPids) {
                ConfigurationImpl config = this.configurationStore.findConfiguration(qualifiedPid);
                if (config == null) continue;
                try {
                    String location;
                    config.lock();
                    if (config.isDeleted()) continue;
                    if (config.getFactoryPid() != null) {
                        this.configurationAdminFactory.warn("Configuration for service.pid=" + qualifiedPid + " should only be used by a " + ManagedServiceFactory.class.getName());
                    }
                    boolean shouldBind = (location = config.getLocation()) == null || !location.startsWith("?");
                    boolean hasLocPermission = this.configurationAdminFactory.checkTargetPermission(location, reference);
                    if (!hasLocPermission) continue;
                    if (shouldBind && config.bind(ConfigurationAdminImpl.getLocation(reference.getBundle())) || !shouldBind) {
                        Dictionary<String, Object> properties = this.configurationAdminFactory.modifyConfiguration(reference, config);
                        this.asynchUpdated(service, properties);
                        foundConfig = true;
                        break;
                    }
                    this.configurationAdminFactory.warn("Configuration for service.pid=" + qualifiedPid + " could not be bound to " + ConfigurationAdminImpl.getLocation(reference.getBundle()));
                }
                finally {
                    config.unlock();
                }
            }
            if (foundConfig) continue;
            this.asynchUpdated(service, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<String>> trackManagedService(ServiceReference<ManagedService> reference) {
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            return this.targets.add(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackManagedService(ServiceReference<ManagedService> reference) {
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            this.targets.remove(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceReference<ManagedService>> getManagedServiceReferences(String pid) {
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            List<ServiceReference<ManagedService>> temp;
            List<ServiceReference<ManagedService>> refs = temp = this.targets.getTargets(pid);
            Collections.sort(refs, Collections.reverseOrder());
            return refs;
        }
    }

    private void asynchUpdated(ManagedService service, Dictionary<String, ?> properties) {
        this.configurationAdminFactory.cancelExecuteCoordinated(service);
        this.configurationAdminFactory.executeCoordinated(service, () -> this.queue.put(() -> {
            try {
                service.updated(properties);
            }
            catch (ConfigurationException e) {
                Throwable cause = e.getCause();
                this.configurationAdminFactory.error(e.getMessage(), cause != null ? cause : e);
            }
            catch (Throwable t) {
                this.configurationAdminFactory.error(t.getMessage(), t);
            }
        }));
    }
}

