/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.container;

import java.security.Permission;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import java.util.UUID;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.wiring.BundleCapability;

public class InternalUtils {
    public static <T> List<T> asCopy(List<? extends T> list) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("Only RandomAccess lists are supported");
        }
        return new CopyOnFirstWriteList<T>(list);
    }

    public static <T> List<T> asList(List<? extends T> l) {
        return l;
    }

    public static void filterCapabilityPermissions(Collection<? extends BundleCapability> capabilities) {
        if (System.getSecurityManager() == null) {
            return;
        }
        Iterator<? extends BundleCapability> iCapabilities = capabilities.iterator();
        while (iCapabilities.hasNext()) {
            BundleCapability capability = iCapabilities.next();
            Permission permission = InternalUtils.getProvidePermission(capability);
            Bundle provider = capability.getRevision().getBundle();
            if (provider == null || provider.hasPermission(permission)) continue;
            iCapabilities.remove();
        }
    }

    public static Permission getRequirePermission(BundleCapability candidate) {
        String name = candidate.getNamespace();
        if ("osgi.wiring.package".equals(name)) {
            return new PackagePermission(InternalUtils.getPermisionName(candidate), candidate.getRevision().getBundle(), "import");
        }
        if ("osgi.wiring.host".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "fragment");
        }
        if ("osgi.wiring.bundle".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "require");
        }
        return new CapabilityPermission(name, candidate.getAttributes(), candidate.getRevision().getBundle(), "require");
    }

    public static Permission getProvidePermission(BundleCapability candidate) {
        String name = candidate.getNamespace();
        if ("osgi.wiring.package".equals(name)) {
            return new PackagePermission(InternalUtils.getPermisionName(candidate), "exportonly");
        }
        if ("osgi.wiring.host".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "host");
        }
        if ("osgi.wiring.bundle".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "provide");
        }
        return new CapabilityPermission(name, "provide");
    }

    private static String getPermisionName(BundleCapability candidate) {
        Object name = candidate.getAttributes().get(candidate.getNamespace());
        if (name instanceof String) {
            return (String)name;
        }
        if (name instanceof Collection) {
            Collection names = (Collection)name;
            return names.isEmpty() ? "unknown" : names.iterator().next().toString();
        }
        return "unknown";
    }

    public static String newUUID(EquinoxConfiguration config) {
        boolean useSecureRandom = "true".equals(config.getConfiguration("equinox.uuid.secure"));
        byte[] uuidBytes = new byte[16];
        if (useSecureRandom) {
            new SecureRandom().nextBytes(uuidBytes);
        } else {
            new Random().nextBytes(uuidBytes);
        }
        uuidBytes[6] = (byte)(uuidBytes[6] & 0xF);
        uuidBytes[6] = (byte)(uuidBytes[6] | 0x40);
        uuidBytes[8] = (byte)(uuidBytes[8] & 0x3F);
        uuidBytes[8] = (byte)(uuidBytes[8] | 0x80);
        long mostSignificantBits = 0L;
        long leastSignificantBits = 0L;
        int i = 0;
        while (i < 8) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(uuidBytes[i] & 0xFF);
            ++i;
        }
        i = 8;
        while (i < 16) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(uuidBytes[i] & 0xFF);
            ++i;
        }
        return new UUID(mostSignificantBits, leastSignificantBits).toString();
    }

    public static <E> Enumeration<E> asEnumeration(final Iterator<E> it) {
        return new Enumeration<E>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public E nextElement() {
                return it.next();
            }
        };
    }

    private static final class CopyOnFirstWriteList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private List<T> copy;
        private boolean copied = false;

        CopyOnFirstWriteList(List<? extends T> list) {
            this.copy = InternalUtils.asList(list);
        }

        @Override
        public T get(int index) {
            return this.copy.get(index);
        }

        @Override
        public int size() {
            return this.copy.size();
        }

        @Override
        public void add(int index, T element) {
            this.ensureCopied();
            this.copy.add(index, element);
            ++this.modCount;
        }

        @Override
        public T remove(int index) {
            this.ensureCopied();
            T removed = this.copy.remove(index);
            ++this.modCount;
            return removed;
        }

        @Override
        public T set(int index, T element) {
            this.ensureCopied();
            T set = this.copy.set(index, element);
            ++this.modCount;
            return set;
        }

        private void ensureCopied() {
            if (!this.copied) {
                this.copy = new ArrayList<T>(this.copy);
                this.copied = true;
            }
        }
    }
}

