/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.ResponseMessage;

public class ProtocolMessageWriter {
    private final JsonObject head = new JsonObject();
    private final List<Operation> operations = new ArrayList<Operation>();
    private Operation pendingOperation;
    private boolean alreadyCreated;

    public void appendHead(String property, int value) {
        this.appendHead(property, JsonValue.valueOf(value));
    }

    public void appendHead(String property, String value) {
        this.appendHead(property, JsonValue.valueOf(value));
    }

    public void appendHead(String property, JsonValue value) {
        this.ensureMessagePending();
        this.head.add(property, value);
    }

    public void appendCreate(String target, String type) {
        this.prepareOperation(new Operation.CreateOperation(target, type));
    }

    public void appendSet(String target, String property, int value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, double value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, boolean value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, String value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, JsonValue value) {
        Operation.CreateOperation createOperation = this.findPendingOperation(target, Operation.CreateOperation.class);
        if (createOperation != null) {
            createOperation.putProperty(property, value);
        } else {
            Operation.SetOperation setOperation = this.findPendingOperation(target, Operation.SetOperation.class);
            if (setOperation == null) {
                setOperation = new Operation.SetOperation(target);
                this.prepareOperation(setOperation);
            }
            setOperation.putProperty(property, value);
        }
    }

    public void appendListen(String target, String eventType, boolean listen) {
        Operation.ListenOperation operation = this.findPendingOperation(target, Operation.ListenOperation.class);
        if (operation == null) {
            operation = new Operation.ListenOperation(target);
            this.prepareOperation(operation);
        }
        operation.putListener(eventType, listen);
    }

    public void appendCall(String target, String methodName, JsonObject parameters) {
        this.prepareOperation(new Operation.CallOperation(target, methodName, parameters));
    }

    public void appendDestroy(String target) {
        this.prepareOperation(new Operation.DestroyOperation(target));
    }

    private void prepareOperation(Operation operation) {
        this.ensureMessagePending();
        this.appendPendingOperation();
        this.pendingOperation = operation;
    }

    public ResponseMessage createMessage() {
        this.ensureMessagePending();
        this.alreadyCreated = true;
        return this.createMessageObject();
    }

    private void ensureMessagePending() {
        if (this.alreadyCreated) {
            throw new IllegalStateException("Message already created");
        }
    }

    private ResponseMessage createMessageObject() {
        this.appendPendingOperation();
        return new ResponseMessage(this.head, this.operations);
    }

    private <T extends Operation> T findPendingOperation(String target, Class<T> type) {
        boolean matches = this.pendingOperation != null && this.pendingOperation.getClass().equals(type) && this.pendingOperation.getTarget().equals(target);
        return (T)(matches ? this.pendingOperation : null);
    }

    private void appendPendingOperation() {
        if (this.pendingOperation != null) {
            this.operations.add(this.pendingOperation);
        }
    }
}

