/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.internal.databinding.IdentitySet;

public class ObservablesManager {
    private Set<IObservable> managedObservables = new IdentitySet<IObservable>();
    private Set<IObservable> excludedObservables = new IdentitySet<IObservable>();
    private Map<DataBindingContext, ManagerEntry> contexts = new HashMap<DataBindingContext, ManagerEntry>();

    public void addObservable(IObservable observable) {
        this.managedObservables.add(observable);
    }

    public void excludeObservable(IObservable observable) {
        this.excludedObservables.add(observable);
    }

    public void addObservablesFromContext(DataBindingContext context, boolean trackTargets, boolean trackModels) {
        if (trackTargets || trackModels) {
            this.contexts.put(context, new ManagerEntry(false, trackTargets, trackModels));
        }
    }

    public void addContext(DataBindingContext context, boolean trackTargets, boolean trackModels) {
        this.contexts.put(context, new ManagerEntry(true, trackTargets, trackModels));
    }

    public void runAndCollect(Runnable runnable) {
        IObservable[] collected;
        IObservable[] iObservableArray = collected = ObservableTracker.runAndCollect((Runnable)runnable);
        int n = collected.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable observable = iObservableArray[n2];
            this.addObservable(observable);
            ++n2;
        }
    }

    public void dispose() {
        IdentitySet<IObservable> observables = new IdentitySet<IObservable>();
        observables.addAll(this.managedObservables);
        for (Map.Entry<DataBindingContext, ManagerEntry> e : this.contexts.entrySet()) {
            DataBindingContext context = e.getKey();
            ManagerEntry entry = e.getValue();
            for (Binding binding : context.getBindings()) {
                if (entry.disposeTargets) {
                    observables.addAll((Collection<IObservable>)binding.getTargets());
                }
                if (!entry.disposeModels) continue;
                observables.addAll((Collection<IObservable>)binding.getModels());
            }
            if (!entry.disposeContext) continue;
            context.dispose();
        }
        observables.removeAll(this.excludedObservables);
        for (IObservable observable : observables) {
            observable.dispose();
        }
    }

    private static class ManagerEntry {
        public final boolean disposeContext;
        public final boolean disposeTargets;
        public final boolean disposeModels;

        public ManagerEntry(boolean disposeContext, boolean disposeTargets, boolean disposeModels) {
            this.disposeContext = disposeContext;
            this.disposeTargets = disposeTargets;
            this.disposeModels = disposeModels;
        }
    }
}

