/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerValueProperty;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.internal.databinding.viewers.ViewerObservableValueDecorator;
import org.eclipse.jface.viewers.Viewer;

public abstract class ViewerValueProperty<S, T>
extends SimpleValueProperty<S, T>
implements IViewerValueProperty<S, T> {
    @Override
    public IObservableValue<T> observe(S source) {
        if (source instanceof Viewer) {
            return this.observe((Viewer)source);
        }
        return super.observe(source);
    }

    public IObservableValue<T> observe(Realm realm, S source) {
        ViewerObservableValueDecorator observable = super.observe(realm, source);
        if (source instanceof Viewer) {
            observable = new ViewerObservableValueDecorator(observable, (Viewer)source);
        }
        return observable;
    }

    @Override
    public IViewerObservableValue<T> observe(Viewer viewer) {
        return (IViewerObservableValue)this.observe(SWTObservables.getRealm(viewer.getControl().getDisplay()), viewer);
    }

    @Override
    public IViewerObservableValue<T> observeDelayed(int delay, Viewer viewer) {
        return ViewersObservables.observeDelayedValue(delay, this.observe(viewer));
    }
}

