/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.AdapterManager;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.events.EventAdapter;
import org.eclipse.rwt.internal.events.IEventAdapter;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.internal.widgets.UntypedEventAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class Widget
implements Adaptable {
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int DISPOSED = 1;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int SKIN_NEEDED = 0x200000;
    int style;
    int state;
    Display display;
    private Object data;
    private AdapterManager adapterManager;
    private IWidgetAdapter widgetAdapter;
    private IEventAdapter eventAdapter;
    private UntypedEventAdapter untypedAdapter;
    private IWidgetGraphicsAdapter widgetGraphicsAdapter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        if (parent == null) {
            SWT.error(4);
        }
        this.style = style;
        this.display = parent.display;
        this.reskinWidget();
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.events.IEventAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.eventAdapter == null) {
                this.eventAdapter = new EventAdapter();
            }
            result = this.eventAdapter;
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.rwt.lifecycle.IWidgetAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                if (this.widgetAdapter == null) {
                    this.widgetAdapter = new WidgetAdapter();
                }
                result = this.widgetAdapter;
            } else {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz3) {
                    result = RWTFactory.getThemeAdapterManager().getThemeAdapter(this);
                } else {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (adapter == clazz4) {
                        if (this.widgetGraphicsAdapter == null) {
                            this.widgetGraphicsAdapter = new WidgetGraphicsAdapter();
                        }
                        result = this.widgetGraphicsAdapter;
                    } else {
                        if (this.adapterManager == null) {
                            this.adapterManager = RWTFactory.getAdapterManager();
                        }
                        result = this.adapterManager.getAdapter(this, adapter);
                    }
                }
            }
        }
        return result;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public Object getData(String key) {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (key == null) {
            this.error(4);
        }
        Object result = null;
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (result == null && i < table.length) {
                if (key.equals(table[i])) {
                    result = table[i + 1];
                }
                i += 2;
            }
        }
        return result;
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    public Display getDisplay() {
        Display display = this.display;
        return display;
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        DisposeEvent.addListener(this, listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        DisposeEvent.removeListener(this, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.untypedAdapter == null) {
            this.untypedAdapter = new UntypedEventAdapter();
        }
        this.untypedAdapter.addListener(this, eventType, listener);
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.untypedAdapter != null) {
            this.untypedAdapter.removeListener(this, eventType, listener);
            if (this.untypedAdapter.isEmpty()) {
                this.untypedAdapter = null;
            }
        }
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        Event newEvent = event == null ? new Event() : event;
        newEvent.widget = this;
        newEvent.type = eventType;
        newEvent.display = this.display;
        UntypedEventAdapter.notifyListeners(eventType, newEvent);
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        boolean result = false;
        if (this.untypedAdapter != null) {
            result = this.untypedAdapter.hasUntypedListener(eventType);
        }
        if (!result) {
            result = UntypedEventAdapter.hasTypedListener(this, eventType);
        }
        return result;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        Listener[] listeners = this.untypedAdapter == null ? new Listener[]{} : this.untypedAdapter.getListeners(eventType);
        return listeners;
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if ((this.state & 0x200000) != 0x200000) {
            this.state |= 0x200000;
            this.display.addSkinnableWidget(this);
        }
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index != -1) {
            string = string.substring(index + 1, string.length());
        }
        return string;
    }

    String getNameText() {
        return "";
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (!this.isValidThread()) {
                this.error(22);
            }
            if ((this.state & 0x1000) == 0) {
                this.state |= 0x1000;
                DisposeEvent disposeEvent = new DisposeEvent(this);
                disposeEvent.processEvent();
            }
            if ((this.state & 1) == 0) {
                this.releaseChildren();
            }
            if ((this.state & 0x800) == 0) {
                this.state |= 0x800;
                this.releaseParent();
                this.releaseWidget();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.rwt.lifecycle.IWidgetAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IWidgetAdapter adapter = (IWidgetAdapter)this.getAdapter(clazz);
                adapter.markDisposed(this);
            }
        }
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isInDispose() {
        return (this.state & 0x1000) != 0;
    }

    void releaseChildren() {
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.adapterManager = null;
        this.untypedAdapter = null;
        this.state |= 1;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    protected void checkWidget() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int result = style;
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((result & mask) == 0) {
            result |= int0;
        }
        if ((result & int0) != 0) {
            result = result & ~mask | int0;
        }
        if ((result & int1) != 0) {
            result = result & ~mask | int1;
        }
        if ((result & int2) != 0) {
            result = result & ~mask | int2;
        }
        if ((result & int3) != 0) {
            result = result & ~mask | int3;
        }
        if ((result & int4) != 0) {
            result = result & ~mask | int4;
        }
        if ((result & int5) != 0) {
            result = result & ~mask | int5;
        }
        return result;
    }

    void checkOrientation(Widget parent) {
        if ((this.style & 0x2000000) == 0 && parent != null && (parent.style & 0x2000000) != 0) {
            this.style |= 0x2000000;
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0, 0, 0, 0, 0);
    }

    void error(int code) {
        SWT.error(code);
    }
}

